/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.user.StashAuthenticationContext;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class EventPublisherImpl
implements EventPublisher,
ApplicationListener<ContextRefreshedEvent> {
    private StashAuthenticationContext authenticationContext;
    private final EventPublisher delegate;

    @Autowired
    public EventPublisherImpl(EventPublisher delegate) {
        this.delegate = delegate;
    }

    public void publish(Object event) {
        if (event instanceof StashEvent) {
            DirectFieldAccessor accessor = new DirectFieldAccessor(event);
            if (this.authenticationContext != null) {
                accessor.setPropertyValue("user", (Object)this.authenticationContext.getCurrentUser());
            }
        }
        this.delegate.publish(event);
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.authenticationContext = (StashAuthenticationContext)event.getApplicationContext().getBean(StashAuthenticationContext.class);
    }
}

