/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.task.TaskAnchorType;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InternalTaskSearchRequest {
    private final Set<Long> anchorIds;
    private final TaskAnchorType anchorType;
    private final InternalTaskContext context;

    private InternalTaskSearchRequest(Builder builder) {
        this.anchorIds = builder.anchorIds;
        this.anchorType = builder.anchorType;
        this.context = builder.context;
    }

    @Nonnull
    public Set<Long> getAnchorIds() {
        return this.anchorIds;
    }

    @Nullable
    public TaskAnchorType getAnchorType() {
        return this.anchorType;
    }

    @Nonnull
    public InternalTaskContext getContext() {
        return this.context;
    }

    public static class Builder {
        private final Set<Long> anchorIds = new HashSet<Long>();
        private TaskAnchorType anchorType;
        private InternalTaskContext context;

        public Builder(@Nonnull InternalTaskContext context) {
            this.context = (InternalTaskContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        }

        @Nonnull
        public InternalTaskSearchRequest build() {
            return new InternalTaskSearchRequest(this);
        }

        @Nonnull
        public Builder anchors(@Nonnull Iterable<Long> anchorIds, @Nonnull TaskAnchorType anchorType) {
            PredicateUtils.addIf((Predicate)Predicates.notNull(), this.anchorIds, anchorIds);
            this.anchorType = (TaskAnchorType)Preconditions.checkNotNull((Object)anchorType, (Object)"anchorType");
            return this;
        }
    }
}

