/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Cacheable
@Entity
@Table(name="sta_user_settings")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalUserSettings {
    public static final String TABLE = "sta_user_settings";
    @Id
    @Column(name="id", nullable=false)
    private final int id;
    @JoinColumn(name="lob_id", foreignKey=@ForeignKey(name="fk_sta_user_settings_lob"), nullable=false)
    @OneToOne(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY, optional=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    private final InternalSharedLob settings;

    protected InternalUserSettings() {
        this.id = -1;
        this.settings = null;
    }

    private InternalUserSettings(Builder builder) {
        this.id = builder.id;
        this.settings = builder.settings;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public InternalSharedLob getSettings() {
        return this.settings;
    }

    public static class Builder {
        private int id;
        private InternalSharedLob settings;

        public Builder() {
        }

        public Builder(@Nonnull InternalUserSettings userSettings) {
            Preconditions.checkNotNull((Object)userSettings, (Object)"userSettings");
            this.id = userSettings.getId();
            this.settings = userSettings.getSettings();
        }

        @Nonnull
        public InternalUserSettings build() {
            Preconditions.checkState(((long)this.id != -1L ? 1 : 0) != 0, (Object)"No user ID is set. The user must be provided");
            return new InternalUserSettings(this);
        }

        @Nonnull
        public Builder user(@Nonnull InternalStashUser value) {
            this.id = ((InternalStashUser)Preconditions.checkNotNull((Object)value, (Object)"user")).getId();
            return this;
        }

        @Nonnull
        public Builder settings(@Nullable InternalSharedLob value) {
            this.settings = value;
            return this;
        }
    }
}

