/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.user.ServiceUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

@Entity
@Table(name="sta_service_user")
@PrimaryKeyJoinColumn(name="user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_service_user_id"))
public class InternalServiceUser
extends InternalStashUser
implements ServiceUser {
    public static final String TABLE = "sta_service_user";
    public static final int MAX_DISPLAY_NAME_LENGTH = 255;
    public static final ToInternalServiceUserVisitor TO_SERVICE_USER = new ToInternalServiceUserVisitor();
    @Column(name="display_name", nullable=false)
    @RequiredString(size=255)
    private final String displayName;

    protected InternalServiceUser() {
        this.displayName = null;
    }

    protected InternalServiceUser(@Nonnull Builder builder) {
        super(builder);
        this.displayName = (String)Preconditions.checkNotNull((Object)builder.displayName, (Object)"displayName");
    }

    @Override
    public <T> T accept(@Nonnull InternalStashUserVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <T> T accept(@Nonnull StashUserVisitor<T> visitor) {
        return (T)visitor.visit((ServiceUser)this);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.displayName;
    }

    @Override
    @Nonnull
    public UserType getType() {
        return UserType.SERVICE;
    }

    @Nonnull
    public String getSlug() {
        Preconditions.checkNotNull((Object)this.getId(), (Object)"A service user slug can only be generated after being persisted");
        return "serviceuser-" + this.getId();
    }

    public static class Builder
    extends InternalStashUser.AbstractBuilder<Builder, InternalServiceUser> {
        private String displayName;

        public Builder() {
        }

        public Builder(InternalServiceUser user) {
            super(user);
            this.displayName = user.displayName;
        }

        @Override
        public InternalServiceUser build() {
            return new InternalServiceUser(this);
        }

        public Builder displayName(String value) {
            this.displayName = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class ToInternalServiceUserVisitor
    implements InternalStashUserVisitor<InternalServiceUser>,
    Function<InternalStashUser, InternalServiceUser> {
        private ToInternalServiceUserVisitor() {
        }

        public InternalServiceUser apply(InternalStashUser user) {
            return user.accept(this);
        }

        @Override
        public InternalServiceUser visit(@Nonnull InternalNormalUser user) {
            return null;
        }

        @Override
        public InternalServiceUser visit(@Nonnull InternalServiceUser user) {
            return user;
        }
    }
}

