/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sta_shared_lob")
@TableGenerator(allocationSize=20, pkColumnValue="sta_shared_lob", name="entityIdGenerator", table="id_sequence")
public class InternalSharedLob
extends InternalAbstractEntity {
    public static final String TABLE = "sta_shared_lob";
    public static final int MAX_LOB_LENGTH = 32768;
    @Column(name="lob_data", nullable=false)
    @Lob
    @RequiredString(size=32768)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String data;

    protected InternalSharedLob() {
        this.data = null;
    }

    private InternalSharedLob(Builder builder) {
        super(builder);
        this.data = builder.data;
    }

    public String getData() {
        return this.data;
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalSharedLob> {
        private String data;

        public Builder() {
        }

        public Builder(InternalSharedLob lob) {
            super(lob);
            this.data = ((InternalSharedLob)Preconditions.checkNotNull((Object)lob, (Object)"lob")).getData();
        }

        @Override
        @Nonnull
        public InternalSharedLob build() {
            Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"LOB data is required");
            return new InternalSharedLob(this);
        }

        public Builder data(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"data");
            Preconditions.checkArgument((StringUtils.length((String)value) <= 32768 ? 1 : 0) != 0, (Object)"The provided LOB data is too long");
            this.data = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

