/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryActivity;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RepositoryActivityVisitor;
import com.atlassian.stash.repository.RepositoryPushActivity;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@DiscriminatorValue(value="6")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_repo_push_act_id"))
@Table(name="sta_repo_push_activity")
public class InternalRepositoryPushActivity
extends InternalRepositoryActivity
implements RepositoryPushActivity {
    public static final String TABLE = "sta_repo_push_activity";
    @CollectionTable(name="sta_repo_push_ref", joinColumns={@JoinColumn(name="activity_id", nullable=false)})
    @ElementCollection(targetClass=InternalRefChange.class)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<RefChange> refChanges;

    protected InternalRepositoryPushActivity() {
        this.refChanges = Sets.newHashSet();
    }

    private InternalRepositoryPushActivity(Builder builder) {
        super(builder);
        this.refChanges = ImmutableSet.copyOf((Collection)builder.refChanges);
    }

    public <T> T accept(@Nonnull RepositoryActivityVisitor<T> visitor) {
        return (T)visitor.visit((RepositoryPushActivity)this);
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    public static class Builder
    extends InternalRepositoryActivity.AbstractRepositoryActivityBuilder<Builder, InternalRepositoryPushActivity> {
        private final Set<RefChange> refChanges = Sets.newHashSet();

        public Builder(@Nonnull InternalRepository repository) {
            super(repository);
        }

        public Builder(@Nonnull InternalRepositoryPushActivity activity) {
            super(activity);
            this.refChanges.addAll(activity.getRefChanges());
        }

        @Override
        @Nonnull
        public InternalRepositoryPushActivity build() {
            return new InternalRepositoryPushActivity(this);
        }

        @Nonnull
        public Builder refChanges(@Nonnull Iterable<RefChange> value) {
            Preconditions.checkNotNull(value, (Object)"refChanges");
            Builder.addIf((Predicate)Predicates.notNull(), this.refChanges, (Iterable)Iterables.transform(value, InternalRefChange.TRANSFORM));
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

