/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.validation.RequiredString;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="sta_drift_request")
public class InternalDriftRequest
implements Initializable {
    private static final String ID_GEN = "driftRequestIdGenerator";
    static final String TABLE = "sta_drift_request";
    @TableGenerator(name="driftRequestIdGenerator", table="id_sequence", pkColumnValue="sta_drift_request", allocationSize=10)
    @Id
    @GeneratedValue(generator="driftRequestIdGenerator", strategy=GenerationType.TABLE)
    @Column(name="id", nullable=false, unique=true)
    private final Long id;
    @Column(name="new_from_hash", nullable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String newFromHash;
    @Column(name="new_to_hash", nullable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String newToHash;
    @Column(name="old_from_hash", nullable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String oldFromHash;
    @Column(name="old_to_hash", nullable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String oldToHash;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_drift_request_pr"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;

    protected InternalDriftRequest() {
        this.id = null;
        this.newToHash = null;
        this.newFromHash = null;
        this.oldToHash = null;
        this.oldFromHash = null;
        this.pullRequest = null;
    }

    public InternalDriftRequest(Long id, InternalPullRequest pullRequest, String oldFromHash, String oldToHash, String newFromHash, String newToHash) {
        this.id = id;
        this.newFromHash = newFromHash;
        this.newToHash = newToHash;
        this.oldFromHash = oldFromHash;
        this.oldToHash = oldToHash;
        this.pullRequest = pullRequest;
    }

    public Long getId() {
        return this.id;
    }

    public String getNewFromHash() {
        return this.newFromHash;
    }

    public String getNewToHash() {
        return this.newToHash;
    }

    public String getOldFromHash() {
        return this.oldFromHash;
    }

    public String getOldToHash() {
        return this.oldToHash;
    }

    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
    }

    public String toString() {
        InternalPullRequest pullRequest = this.getPullRequest();
        return pullRequest.getScopeRepository().getId() + ":" + pullRequest.getId() + "@" + pullRequest.getVersion() + " (" + this.getOldFromHash() + ", " + this.getOldToHash() + ") -> (" + this.getNewFromHash() + ", " + this.getNewToHash() + ")";
    }
}

