/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.project.ProjectVisitor;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;

@DiscriminatorValue(value="0")
@Entity
@PrimaryKeyJoinColumn(name="project_id", referencedColumnName="id")
@Table(name="sta_normal_project")
public class InternalNormalProject
extends InternalProject {
    public static final String TABLE = "sta_normal_project";
    @Column(name="is_public", nullable=false)
    private final boolean publiclyAccessible;

    protected InternalNormalProject() {
        this.publiclyAccessible = false;
    }

    protected InternalNormalProject(Integer id, String key, String name, String description, boolean publiclyAccessible) {
        super(id, key, name, description, ProjectType.NORMAL);
        this.publiclyAccessible = publiclyAccessible;
    }

    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((Project)this);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static class Builder
    extends InternalProject.AbstractBuilder<Builder> {
        private String description;
        private String key;
        private String name;
        private boolean publiclyAccessible;

        public Builder() {
        }

        public Builder(@Nonnull Project project) {
            super(project);
            this.description = project.getDescription();
            this.key = project.getKey();
            this.name = project.getName();
            this.publiclyAccessible = project.isPublic();
        }

        public InternalNormalProject build() {
            return new InternalNormalProject(this.id, this.key, this.name, this.description, this.publiclyAccessible);
        }

        public Builder description(String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this.self();
        }

        public Builder key(String value) {
            this.key = value;
            return this.self();
        }

        public Builder name(String value) {
            this.name = value;
            return this.self();
        }

        public Builder publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

