/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.util.Page;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projections;
import org.hibernate.proxy.HibernateProxy;

public class HibernateUtils {
    private static final Function<Object, Object> INITIALIZER = new Function<Object, Object>(){

        public Object apply(Object entity) {
            return HibernateUtils.initialize(entity);
        }
    };

    private HibernateUtils() {
        throw new UnsupportedOperationException();
    }

    public static <B, D extends B> D cast(@Nullable B baseEntity, @Nonnull Class<D> derivedClass) {
        baseEntity = HibernateUtils.unwrap(baseEntity);
        return (D)((Class)Preconditions.checkNotNull(derivedClass, (Object)"derivedClass")).cast(baseEntity);
    }

    public static long count(@Nonnull Criteria criteria) {
        return (Long)((Criteria)Preconditions.checkNotNull((Object)criteria, (Object)"criteria")).setProjection(Projections.rowCount()).uniqueResult();
    }

    public static <T> T initialize(T entity) {
        if (entity == null) {
            return null;
        }
        if ((entity = HibernateUtils.unwrap(entity)) instanceof Initializable) {
            ((Initializable)entity).initialize();
        }
        return entity;
    }

    public static <T> List<T> initializeList(List<T> list) {
        if (list == null) {
            return null;
        }
        return ImmutableList.copyOf((Collection)Lists.transform(list, HibernateUtils.initializer()));
    }

    public static <T> Page<T> initializePage(Page<T> page) {
        if (page == null) {
            return null;
        }
        return page.transform(HibernateUtils.initializer());
    }

    public static <T> Set<T> initializeSet(Set<T> set) {
        if (set == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform(set, HibernateUtils.initializer()));
    }

    @Nullable
    public static <B, D extends B> D tryCast(@Nullable B baseEntity, @Nonnull Class<D> derivedClass) {
        baseEntity = HibernateUtils.unwrap(baseEntity);
        return ((Class)Preconditions.checkNotNull(derivedClass, (Object)"derivedClass")).isInstance(baseEntity) ? (D)derivedClass.cast(baseEntity) : null;
    }

    private static <T> Function<T, T> initializer() {
        return INITIALIZER;
    }

    private static <T> T unwrap(T entity) {
        if (entity instanceof HibernateProxy) {
            return (T)((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        return entity;
    }
}

