/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.atlassian.stash.user.UserType;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="stash_user")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalStashUser
implements StashUser,
Serializable {
    public static final String ID_GEN = "userIdGenerator";
    public static final String TABLE = "stash_user";
    public static final InternalStashUserVisitor<User> TO_CROWD_USER = new ToCrowdUserVisitor();
    @Id
    @GeneratedValue(generator="userIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="userIdGenerator", table="id_sequence", pkColumnValue="stash_user", allocationSize=50)
    private final Integer id;

    protected InternalStashUser() {
        this.id = null;
    }

    protected InternalStashUser(@Nonnull AbstractBuilder builder) {
        this.id = ((AbstractBuilder)Preconditions.checkNotNull((Object)builder, (Object)"builder")).id;
    }

    public abstract <T> T accept(@Nonnull InternalStashUserVisitor<T> var1);

    public abstract AbstractBuilder copy();

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }

    public String getEmailAddress() {
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    @Nonnull
    public abstract UserType getType();

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean isActive() {
        return false;
    }

    @Nonnull
    public String getUsername() {
        return this.getName();
    }

    private static class ToCrowdUserVisitor
    implements InternalStashUserVisitor<User> {
        private ToCrowdUserVisitor() {
        }

        @Override
        public User visit(@Nonnull InternalNormalUser user) {
            return user.getBackingCrowdUser();
        }

        @Override
        public User visit(@Nonnull InternalServiceUser user) {
            return null;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, T extends InternalStashUser> {
        protected Integer id;

        public AbstractBuilder() {
        }

        public AbstractBuilder(InternalStashUser user) {
            this.id = user.getId();
        }

        public abstract T build();

        public B id(Integer value) {
            this.id = value;
            return this.self();
        }

        protected abstract B self();
    }
}

