/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.text.Normalizer;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="sta_normal_user")
@PrimaryKeyJoinColumn(name="user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_normal_user_id"))
public class InternalNormalUser
extends InternalStashUser {
    public static final IsCrowdBackedUserVisitor IS_CROWD_BACKED = new IsCrowdBackedUserVisitor();
    public static final int MAX_GENERATED_SLUG_LENGTH = 126;
    public static final int MAX_SLUG_RETRY_COUNT = 10;
    public static final String TABLE = "sta_normal_user";
    public static final ToInternalNormalUserVisitor TO_NORMAL_USER = new ToInternalNormalUserVisitor();
    @Transient
    private volatile transient User backingCrowdUser;
    public static final int MAX_NAME_LENGTH = 255;
    @Column(name="name", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String username;
    @Column(name="slug", nullable=false, unique=true)
    private final String slug;
    @Column(name="locale", nullable=true)
    private final Locale locale;

    protected InternalNormalUser() {
        this.backingCrowdUser = null;
        this.slug = null;
        this.username = null;
        this.locale = null;
    }

    protected InternalNormalUser(@Nonnull Builder builder) {
        super(builder);
        this.slug = builder.slug == null ? InternalNormalUser.slugify(builder.name) : builder.slug;
        this.username = IdentifierUtils.toLowerCase((String)builder.name);
        this.backingCrowdUser = builder.crowdUser;
        this.locale = builder.locale;
    }

    @Override
    public <T> T accept(@Nonnull InternalStashUserVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <T> T accept(@Nonnull StashUserVisitor<T> visitor) {
        return (T)visitor.visit((StashUser)this);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public User getBackingCrowdUser() {
        return this.backingCrowdUser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public String getDisplayName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getDisplayName() : this.username;
    }

    @Override
    public String getEmailAddress() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getEmailAddress() : super.getEmailAddress();
    }

    public String getName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getName() : this.username;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Override
    @Nonnull
    public UserType getType() {
        return UserType.NORMAL;
    }

    @Override
    public boolean isActive() {
        return this.backingCrowdUser != null && this.backingCrowdUser.isActive();
    }

    public boolean isCrowdBacked() {
        return this.backingCrowdUser != null;
    }

    public void setBackingCrowdUser(User crowdUser) {
        Preconditions.checkState((this.backingCrowdUser == null ? 1 : 0) != 0, (Object)"You cannot set the backing Crowd user after it's been initialized");
        this.backingCrowdUser = crowdUser;
    }

    public static String generateSlug(SecureTokenGenerator tokenGenerator) {
        String slug = tokenGenerator.generateToken();
        if (slug.length() > 127) {
            slug = slug.substring(0, 127);
        }
        return slug;
    }

    public static String slugify(String name) {
        String slug = Normalizer.normalize(name, Normalizer.Form.NFKD).replaceAll("[:/?#@!$&'()*+,;=%\\\\\\[\\]]", "_");
        if (slug.length() > 126) {
            slug = slug.substring(0, 126);
        }
        return IdentifierUtils.toLowerCase((String)slug);
    }

    public static class IsCrowdBackedUserVisitor
    implements Predicate<InternalStashUser>,
    InternalStashUserVisitor<Boolean> {
        private IsCrowdBackedUserVisitor() {
        }

        public boolean apply(InternalStashUser user) {
            return user.accept(this);
        }

        @Override
        public Boolean visit(@Nonnull InternalNormalUser user) {
            return user.isCrowdBacked();
        }

        @Override
        public Boolean visit(@Nonnull InternalServiceUser user) {
            return Boolean.FALSE;
        }
    }

    public static class ToInternalNormalUserVisitor
    implements InternalStashUserVisitor<InternalNormalUser>,
    Function<InternalStashUser, InternalNormalUser> {
        private ToInternalNormalUserVisitor() {
        }

        public InternalNormalUser apply(InternalStashUser user) {
            return user.accept(this);
        }

        @Override
        public InternalNormalUser visit(@Nonnull InternalNormalUser user) {
            return user;
        }

        @Override
        public InternalNormalUser visit(@Nonnull InternalServiceUser user) {
            return null;
        }
    }

    public static class Builder
    extends InternalStashUser.AbstractBuilder<Builder, InternalNormalUser> {
        private User crowdUser;
        private String name;
        private String slug;
        private Locale locale;

        public Builder() {
        }

        public Builder(InternalNormalUser user) {
            super(user);
            this.name = user.getName();
            this.slug = user.getSlug();
            this.crowdUser = user.getBackingCrowdUser();
            this.locale = user.locale;
        }

        @Override
        public InternalNormalUser build() {
            return new InternalNormalUser(this);
        }

        public Builder name(String value) {
            this.name = value;
            this.slug = InternalNormalUser.slugify(value);
            return this.self();
        }

        public Builder slug(String value) {
            this.slug = Builder.checkSlug(value);
            return this.self();
        }

        public Builder regenerateSlug() {
            this.slug = null;
            return this.self();
        }

        public Builder crowdUser(User value) {
            this.crowdUser = value;
            return this;
        }

        public Builder locale(Locale value) {
            this.locale = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        private static String checkSlug(String slug) {
            Preconditions.checkNotNull((Object)slug, (Object)"slug");
            Preconditions.checkArgument((!slug.trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank slug is required");
            Preconditions.checkArgument((slug.length() <= 127 ? 1 : 0) != 0, (Object)"The provided slug exceeds the maximum allowed length");
            String check = InternalNormalUser.slugify(slug);
            if (slug.length() < 127) {
                Preconditions.checkArgument((boolean)slug.equals(check), (String)"The provided slug is not valid (%s != %s)", (Object[])new Object[]{slug, check});
            } else if (slug.length() == 127) {
                Preconditions.checkArgument((slug.startsWith(check) && Character.isDigit(slug.charAt(126)) ? 1 : 0) != 0, (String)"The provided slug is not valid (%s != %s with a trailing digit)", (Object[])new Object[]{slug, check});
            }
            return slug;
        }
    }
}

