/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.validation.OptionalString;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.Hibernate;

@Entity
@Table(name="sta_pr_rescope_request")
public class InternalRescopeRequest
implements Initializable {
    private static final String ID_GEN = "rescopeRequestIdGenerator";
    static final String TABLE = "sta_pr_rescope_request";
    @TableGenerator(name="rescopeRequestIdGenerator", table="id_sequence", pkColumnValue="sta_pr_rescope_request", allocationSize=43)
    @Id
    @GeneratedValue(generator="rescopeRequestIdGenerator", strategy=GenerationType.TABLE)
    @Column(name="id", nullable=false, unique=true)
    private final Long id;
    @Column(name="branch_fqn")
    @OptionalString(size=1024)
    private final String branchId;
    @JoinColumn(name="repo_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalStashUser user;

    protected InternalRescopeRequest() {
        this.branchId = null;
        this.id = null;
        this.user = null;
    }

    public InternalRescopeRequest(Long id, InternalRepository repository, String branchId, InternalStashUser user) {
        this.id = id;
        this.branchId = branchId;
        this.repository = repository;
        this.user = user;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public Long getId() {
        return this.id;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public InternalStashUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        Hibernate.initialize((Object)this.getUser());
    }
}

