/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.content.Diff;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestCommentActivity;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="2")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_pr_com_act_id"))
@Table(name="sta_pr_comment_activity", indexes={@Index(name="idx_sta_pr_com_act_action", columnList="comment_action"), @Index(name="idx_sta_pr_com_act_anchor", columnList="anchor_id"), @Index(name="idx_sta_pr_com_act_comment", columnList="comment_id")})
public class InternalPullRequestCommentActivity
extends InternalPullRequestActivity
implements PullRequestCommentActivity {
    public static final String TABLE = "sta_pr_comment_activity";
    @JoinColumn(name="comment_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_com_act_comment"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="comment_action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.comment.CommentAction")})
    private final CommentAction commentAction;
    @JoinColumn(name="anchor_id", foreignKey=@ForeignKey(name="fk_sta_pr_com_act_anchor"))
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalPullRequestDiffCommentAnchor commentAnchor;
    @Transient
    private Diff diff;

    protected InternalPullRequestCommentActivity() {
        this.comment = null;
        this.commentAction = null;
        this.commentAnchor = null;
    }

    private InternalPullRequestCommentActivity(Builder builder) {
        super(builder);
        this.comment = builder.comment;
        this.commentAction = builder.commentAction;
        this.commentAnchor = builder.commentAnchor;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestCommentActivity)this);
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    public InternalPullRequestDiffCommentAnchor getCommentAnchor() {
        return this.commentAnchor;
    }

    public Diff getDiff() {
        return this.diff;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getComment());
        HibernateUtils.initialize(this.getCommentAnchor());
    }

    public void setDiff(Diff value) {
        if (this.diff != null) {
            throw new IllegalStateException("You cannot set the diff after it's been initialized");
        }
        this.diff = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestCommentActivity> {
        private InternalComment comment;
        private CommentAction commentAction;
        private InternalPullRequestDiffCommentAnchor commentAnchor;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.COMMENTED);
        }

        public Builder(@Nonnull InternalPullRequestCommentActivity activity) {
            super(activity);
            this.comment = activity.getComment();
            this.commentAction = activity.getCommentAction();
            this.commentAnchor = activity.getCommentAnchor();
        }

        @Override
        @Nonnull
        public InternalPullRequestCommentActivity build() {
            return new InternalPullRequestCommentActivity(this);
        }

        @Nonnull
        public Builder comment(@Nonnull InternalComment value) {
            this.comment = (InternalComment)Preconditions.checkNotNull((Object)value, (Object)"comment");
            return this.self();
        }

        @Nonnull
        public Builder commentAction(@Nonnull CommentAction value) {
            this.commentAction = (CommentAction)Preconditions.checkNotNull((Object)value, (Object)"commentAction");
            return this.self();
        }

        @Nonnull
        public Builder commentAnchor(@Nullable InternalPullRequestDiffCommentAnchor value) {
            this.commentAnchor = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

