/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.commit.CommitDiscussionCommentActivity;
import com.atlassian.stash.content.Diff;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionActivity;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentAnchor;
import com.atlassian.stash.repository.RepositoryActivityVisitor;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="5")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_cmt_disc_com_act_id"))
@Table(name="sta_cmt_disc_comment_activity", indexes={@Index(name="idx_sta_cmt_disc_com_act_act", columnList="comment_action"), @Index(name="idx_sta_cmt_disc_com_act_anc", columnList="anchor_id"), @Index(name="idx_sta_cmt_disc_com_act_com", columnList="comment_id")})
public class InternalCommitDiscussionCommentActivity
extends InternalCommitDiscussionActivity
implements CommitDiscussionCommentActivity {
    public static final String TABLE = "sta_cmt_disc_comment_activity";
    @JoinColumn(name="comment_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_cmt_disc_com_act_com"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="comment_action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.comment.CommentAction")})
    private final CommentAction commentAction;
    @JoinColumn(name="anchor_id", foreignKey=@ForeignKey(name="fk_sta_cmt_disc_com_act_anc"))
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalCommitDiscussionCommentAnchor commentAnchor;
    @Transient
    private Diff diff;

    protected InternalCommitDiscussionCommentActivity() {
        this.comment = null;
        this.commentAction = null;
        this.commentAnchor = null;
    }

    private InternalCommitDiscussionCommentActivity(Builder builder) {
        super(builder);
        this.comment = builder.comment;
        this.commentAction = builder.commentAction;
        this.commentAnchor = builder.commentAnchor;
    }

    public <T> T accept(@Nonnull RepositoryActivityVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussionCommentActivity)this);
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    public InternalCommitDiscussionCommentAnchor getCommentAnchor() {
        return this.commentAnchor;
    }

    public Diff getDiff() {
        return this.diff;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getComment());
        HibernateUtils.initialize(this.getCommentAnchor());
    }

    public void setDiff(Diff value) {
        if (this.diff != null) {
            throw new IllegalStateException("You cannot set the diff after it's been initialized");
        }
        this.diff = value;
    }

    public static class Builder
    extends InternalCommitDiscussionActivity.AbstractCommitDiscussionActivityBuilder<Builder, InternalCommitDiscussionCommentActivity> {
        private InternalComment comment;
        private CommentAction commentAction;
        private InternalCommitDiscussionCommentAnchor commentAnchor;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            super(discussion);
        }

        public Builder(@Nonnull InternalCommitDiscussionCommentActivity activity) {
            super(activity);
            this.comment = activity.getComment();
            this.commentAction = activity.getCommentAction();
            this.commentAnchor = activity.getCommentAnchor();
        }

        @Override
        @Nonnull
        public InternalCommitDiscussionCommentActivity build() {
            return new InternalCommitDiscussionCommentActivity(this);
        }

        @Nonnull
        public Builder comment(@Nonnull InternalComment value) {
            this.comment = (InternalComment)Preconditions.checkNotNull((Object)value, (Object)"comment");
            return this.self();
        }

        @Nonnull
        public Builder commentAction(@Nonnull CommentAction value) {
            this.commentAction = (CommentAction)Preconditions.checkNotNull((Object)value, (Object)"commentAction");
            return this.self();
        }

        @Nonnull
        public Builder commentAnchor(@Nullable InternalCommitDiscussionCommentAnchor value) {
            this.commentAnchor = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

