/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.pull.RescopeDetails;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public class InternalRescopeDetails
implements RescopeDetails,
Serializable {
    public static final InternalRescopeDetails EMPTY = new InternalRescopeDetails();
    private static final Comparator<Changeset> ORDER = new Comparator<Changeset>(){

        @Override
        public int compare(Changeset lhs, Changeset rhs) {
            return rhs.getAuthorTimestamp().compareTo(lhs.getAuthorTimestamp());
        }
    };
    private final List<Changeset> changesets;
    private final int total;

    private InternalRescopeDetails() {
        this.changesets = Collections.emptyList();
        this.total = 0;
    }

    private InternalRescopeDetails(List<Changeset> changesets, int total) {
        this.changesets = changesets;
        this.total = total;
    }

    @Nonnull
    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public static class Builder
    extends BuilderSupport {
        private final List<Changeset> changesets;
        private int total;

        public Builder() {
            this.changesets = Lists.newArrayList();
        }

        public Builder(@Nonnull InternalRescopeDetails details) {
            this.changesets = Lists.newArrayList(((InternalRescopeDetails)Preconditions.checkNotNull((Object)details, (Object)"details")).getChangesets());
            this.total = details.getTotal();
        }

        public InternalRescopeDetails build() {
            Collections.sort(this.changesets, ORDER);
            return new InternalRescopeDetails((List)ImmutableList.copyOf(this.changesets), this.total);
        }

        public Builder changeset(Changeset value) {
            Builder.addIf((Predicate)Predicates.notNull(), this.changesets, (Object)value);
            return this;
        }

        public Builder changesets(Iterable<Changeset> value) {
            Builder.addIf((Predicate)Predicates.notNull(), this.changesets, value);
            return this;
        }

        public Builder total(int value) {
            this.total = value;
            return this;
        }
    }
}

