/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class InternalPullRequestRescopeCommit {
    @Column(name="action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction")})
    private final PullRequestRescopeCommitAction action;
    @Column(name="changeset_id", nullable=false, length=40)
    @RequiredString(size=40)
    private final String changesetId;

    protected InternalPullRequestRescopeCommit() {
        this.action = null;
        this.changesetId = null;
    }

    private InternalPullRequestRescopeCommit(String changesetId, PullRequestRescopeCommitAction action) {
        this.action = action;
        this.changesetId = changesetId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalPullRequestRescopeCommit) {
            InternalPullRequestRescopeCommit c = (InternalPullRequestRescopeCommit)o;
            return StringUtils.equals((CharSequence)this.getChangesetId(), (CharSequence)c.getChangesetId());
        }
        return false;
    }

    @Nonnull
    public PullRequestRescopeCommitAction getAction() {
        return this.action;
    }

    @Nonnull
    public String getChangesetId() {
        return this.changesetId;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.getChangesetId());
    }

    public static class Builder {
        private PullRequestRescopeCommitAction action;
        private String changesetId;

        @Nonnull
        public Builder action(@Nonnull PullRequestRescopeCommitAction value) {
            this.action = (PullRequestRescopeCommitAction)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"action"));
            return this;
        }

        @Nonnull
        public InternalPullRequestRescopeCommit build() {
            return new InternalPullRequestRescopeCommit(this.changesetId, this.action);
        }

        @Nonnull
        public Builder changesetId(@Nonnull String value) {
            this.changesetId = (String)Preconditions.checkNotNull((Object)value, (Object)"changesetId");
            return this;
        }
    }
}

