/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.CommentableVisitor;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.ParticipableVisitor;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryScoped;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.util.BuilderSupport;
import com.atlassian.stash.watcher.WatchableVisitor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Cacheable
@Entity
@Table(name="sta_pull_request", indexes={@Index(name="idx_sta_pull_request_from", columnList="from_repository_id, from_branch_fqn"), @Index(name="idx_sta_pull_request_state", columnList="pr_state"), @Index(name="idx_sta_pull_request_to", columnList="to_repository_id, to_branch_fqn")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequest
implements Initializable,
InternalCommentable,
InternalParticipable<InternalPullRequestParticipant>,
InternalWatchable,
PullRequest,
RepositoryScoped {
    public static final String ID_GEN = "pullRequestIdGenerator";
    public static final String TABLE = "sta_pull_request";
    public static final Function<InternalPullRequest, Long> TO_GLOBAL_ID = new Function<InternalPullRequest, Long>(){

        public Long apply(InternalPullRequest pullRequest) {
            return pullRequest.getGlobalId();
        }
    };
    @Transient
    private transient AttributeMap attributes;
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="description")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String description;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_from_repo"), joinColumns={@JoinColumn(name="from_repository_id", nullable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="from_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="from_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="from_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef fromRef;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_pull_request", name="pullRequestIdGenerator", table="id_sequence")
    private final Long id;
    @OneToMany(mappedBy="pullRequest", targetEntity=InternalPullRequestParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final Set<PullRequestParticipant> participants;
    @Column(name="scoped_id", nullable=false)
    private Long scopedId;
    @Column(name="pr_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestState")})
    private final PullRequestState state;
    @Column(name="title", nullable=false)
    private final String title;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_to_repo"), joinColumns={@JoinColumn(name="to_repository_id", nullable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="to_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="to_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="to_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef toRef;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @JoinColumn(name="watchable_id", updatable=false)
    @OneToMany(targetEntity=InternalWatcher.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    @Where(clause="watchable_type = 1")
    private final Set<InternalWatcher> watchers;

    protected InternalPullRequest() {
        this.updatedDate = null;
        this.createdDate = null;
        this.title = null;
        this.description = null;
        this.toRef = null;
        this.fromRef = null;
        this.scopedId = null;
        this.id = null;
        this.participants = Sets.newHashSet();
        this.state = null;
        this.version = 0;
        this.watchers = Sets.newHashSet();
    }

    private InternalPullRequest(Builder builder) {
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.fromRef = builder.fromRef;
        this.id = builder.id;
        this.participants = Sets.newHashSet((Iterable)builder.participants);
        this.scopedId = builder.scopedId;
        this.state = builder.state;
        this.title = builder.title;
        this.toRef = builder.toRef;
        this.updatedDate = builder.updatedDate;
        this.version = builder.version;
        this.watchers = Sets.newHashSet((Iterable)builder.watchers);
    }

    @Override
    public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull ParticipableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((PullRequest)this);
    }

    @Override
    public void addParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.add(participant);
    }

    @Override
    public void addWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Nonnull
    public AttributeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = AttributeMap.EMPTY;
        }
        return this.attributes;
    }

    @Nonnull
    public Set<String> getAttributeValues(String name) {
        Set result = this.getAttributes().get((Object)name);
        return result == null ? Collections.emptySet() : result;
    }

    @Nonnull
    public PullRequestParticipant getAuthor() {
        Set<PullRequestParticipant> authors = this.getParticipantsFilteredByRole(PullRequestRole.AUTHOR);
        if (authors.isEmpty()) {
            throw new IllegalStateException("Pull request author could not be found in its participants");
        }
        if (authors.size() > 1) {
            throw new IllegalStateException("Pull request has more than one author");
        }
        return (PullRequestParticipant)Iterables.getFirst(authors, null);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public InternalPullRequestRef getFromRef() {
        return this.fromRef;
    }

    public Long getGlobalId() {
        return this.id;
    }

    public Long getId() {
        return this.getScopedId();
    }

    public Set<PullRequestParticipant> getAllParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    @Nonnull
    public Set<PullRequestParticipant> getParticipants() {
        return this.getParticipantsFilteredByRole(PullRequestRole.PARTICIPANT);
    }

    @Nonnull
    public Set<PullRequestParticipant> getReviewers() {
        return this.getParticipantsFilteredByRole(PullRequestRole.REVIEWER);
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getToRef().getRepository();
    }

    @Override
    @Nonnull
    public String getScopeType() {
        return InternalPullRequest.class.getSimpleName();
    }

    @Override
    public Long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public Set<InternalWatcher> getWatchers() {
        return Collections.unmodifiableSet(this.watchers);
    }

    @Nonnull
    public InternalPullRequestRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getFromRef());
        HibernateUtils.initialize(this.getToRef());
        Hibernate.initialize(this.getAllParticipants());
        Hibernate.initialize(this.getWatchers());
        for (PullRequestParticipant participant : this.getAllParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
        for (InternalWatcher watcher : this.getWatchers()) {
            Hibernate.initialize((Object)watcher);
            Hibernate.initialize((Object)watcher.getUser());
        }
    }

    public boolean isClosed() {
        return this.getState() != PullRequestState.OPEN;
    }

    public boolean isCrossRepository() {
        return ObjectUtils.notEqual((Object)this.getFromRef().getRepository().getId(), (Object)this.getToRef().getRepository().getId());
    }

    public boolean isOpen() {
        return this.getState() == PullRequestState.OPEN;
    }

    @Override
    public void removeParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    public void removeWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public void setAttributes(AttributeMap attributes) {
        if (this.attributes != null) {
            throw new IllegalStateException("Attributes have already been set; you cannot override once set.");
        }
        this.attributes = attributes;
    }

    @Override
    public void setScopedId(long value) {
        if (this.scopedId != null) {
            throw new IllegalStateException("You cannot set the scoped ID after it's been initialized");
        }
        this.scopedId = value;
    }

    private Set<PullRequestParticipant> getParticipantsFilteredByRole(PullRequestRole role) {
        return ImmutableSet.copyOf((Collection)Sets.filter(this.getAllParticipants(), (Predicate)role.getFilter()));
    }

    public static class Builder
    extends BuilderSupport {
        private final AttributeMap.Builder attributes = new AttributeMap.Builder();
        private final Set<PullRequestParticipant> participants = Sets.newHashSet();
        private final Set<InternalWatcher> watchers = Sets.newHashSet();
        private Date createdDate;
        private String description;
        private InternalPullRequestRef fromRef;
        private Long id;
        private Long scopedId;
        private PullRequestState state;
        private String title;
        private InternalPullRequestRef toRef;
        private Date updatedDate;
        private int version;

        public Builder() {
        }

        public Builder(InternalPullRequest request) {
            this();
            this.createdDate = request.getCreatedDate();
            this.description = request.getDescription();
            this.fromRef = request.getFromRef();
            this.id = request.getGlobalId();
            this.scopedId = request.getScopedId();
            this.state = request.getState();
            this.title = request.getTitle();
            this.toRef = request.getToRef();
            this.updatedDate = request.getUpdatedDate();
            this.version = request.getVersion();
            this.attributes.add(request.getAttributes());
            this.participants.addAll(request.getAllParticipants());
            this.watchers.addAll(request.getWatchers());
        }

        public Builder attribute(String name, String value) {
            this.attributes.add(name, new String[]{value});
            return this;
        }

        public Builder attributes(AttributeMap value) {
            this.attributes.add(value);
            return this;
        }

        public Builder attributes(String name, String value, String ... values) {
            this.attributes.add(name, new String[]{value}).add(name, values);
            return this;
        }

        public Builder attributes(String name, Iterable<String> values) {
            this.attributes.add(name, values);
            return this;
        }

        public InternalPullRequest build() {
            return new InternalPullRequest(this);
        }

        public Builder createdDate(Date value) {
            this.createdDate = value;
            return this;
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder fromRef(InternalPullRequestRef value) {
            this.fromRef = value;
            return this;
        }

        public Builder globalId(Long value) {
            this.id = value;
            return this;
        }

        public Builder participant(PullRequestParticipant value) {
            return this.participants(value, new PullRequestParticipant[0]);
        }

        public Builder participants(Iterable<PullRequestParticipant> values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.participants, values);
            return this;
        }

        public Builder participants(PullRequestParticipant value, PullRequestParticipant ... values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.participants, (Object)value, (Object[])values);
            return this;
        }

        public Builder scopedId(Long value) {
            this.scopedId = value;
            return this;
        }

        public Builder state(PullRequestState value) {
            this.state = value;
            return this;
        }

        public Builder title(String value) {
            this.title = Builder.checkNotBlank((String)value, (String)"title");
            return this;
        }

        public Builder toRef(InternalPullRequestRef value) {
            this.toRef = value;
            return this;
        }

        public Builder updatedDate(Date value) {
            this.updatedDate = value;
            return this;
        }

        public Builder watcher(InternalWatcher value) {
            return this.watchers(value, new InternalWatcher[0]);
        }

        public Builder watchers(Iterable<InternalWatcher> values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.watchers, values);
            return this;
        }

        public Builder watchers(InternalWatcher value, InternalWatcher ... values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.watchers, (Object)value, (Object[])values);
            return this;
        }
    }
}

