/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.watcher.Watchable;
import com.atlassian.stash.watcher.Watcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="sta_watcher", uniqueConstraints={@UniqueConstraint(name="uq_sta_watchable", columnNames={"watchable_id", "watchable_type", "user_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalWatcher
implements Initializable,
Watcher {
    public static final String ID_GEN = "watcherIdGenerator";
    public static final String TABLE = "sta_watcher";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="watcherIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_watcher", name="watcherIdGenerator", table="id_sequence")
    private final Long id;
    @ForeignKey(name="fk_sta_watcher_user")
    @JoinColumn(name="user_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalStashUser user;
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="watchable_type", nullable=false), optional=false)
    @AnyMetaDef(idType="long", metaType="integer", metaValues={@MetaValue(targetEntity=InternalPullRequest.class, value="1")})
    @JoinColumn(name="watchable_id", nullable=false)
    private Watchable watchable;

    protected InternalWatcher() {
        this.id = null;
        this.user = null;
    }

    private InternalWatcher(Long id, InternalStashUser user, Watchable watchable) {
        this.id = id;
        this.user = user;
        this.watchable = watchable;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    @Nonnull
    public InternalStashUser getUser() {
        return this.user;
    }

    @Nonnull
    public Watchable getWatchable() {
        return this.watchable;
    }

    @Override
    public void initialize() {
        this.watchable = HibernateUtils.initialize(this.getWatchable());
        Hibernate.initialize((Object)this.getUser());
    }

    public static class Builder {
        private Long id;
        private InternalStashUser user;
        private Watchable watchable;

        public Builder() {
        }

        public Builder(InternalWatcher watcher) {
            this.id = watcher.getId();
            this.user = watcher.getUser();
            this.watchable = watcher.getWatchable();
        }

        public InternalWatcher build() {
            return new InternalWatcher(this.id, this.user, this.watchable);
        }

        public Builder id(Long value) {
            this.id = value;
            return this;
        }

        public Builder user(InternalStashUser value) {
            this.user = value;
            return this;
        }

        public Builder watchable(Watchable value) {
            this.watchable = value;
            return this;
        }
    }
}

