/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.validation.RepositoryUniqueness;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryUniquenessValidator
implements ConstraintValidator<RepositoryUniqueness, InternalRepository> {
    private I18nService i18nService;
    private String message;
    private RepositoryService repositoryService;
    private SecurityService securityService;

    public void initialize(RepositoryUniqueness annotation) {
        this.message = annotation.message();
    }

    public boolean isValid(final InternalRepository value, ConstraintValidatorContext context) {
        if (value == null || this.repositoryService == null || this.securityService == null) {
            return true;
        }
        if (value.getProject() == null || value.getSlug() == null) {
            return false;
        }
        Repository found = (Repository)this.securityService.doWithPermission("validate repository uniqueness", Permission.REPO_READ, (Operation)new UncheckedOperation<Repository>(){

            public Repository perform() throws RuntimeException {
                return RepositoryUniquenessValidator.this.repositoryService.getBySlug(value.getProject().getKey(), value.getSlug());
            }
        });
        if (found == null || ObjectUtils.equals((Object)found.getId(), (Object)value.getId())) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(this.formatMessage(found));
        builder.addNode("name");
        builder.addConstraintViolation();
        return false;
    }

    @Autowired
    public void setI18nService(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    private String formatMessage(Repository found) {
        return this.i18nService.getText(this.message, "This repository URL is already taken by ''{0}'' in ''{1}''", new Object[]{found.getName(), found.getProject().getName()});
    }
}

