/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.validation.ProjectNameUnique;
import com.atlassian.stash.internal.validation.ProjectValidator;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Preconditions;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectNameValidator
implements ProjectValidator<ProjectNameUnique> {
    private String message;
    private ProjectService projectService;
    private SecurityService securityService;

    public void initialize(ProjectNameUnique annotation) {
        this.message = ((ProjectNameUnique)Preconditions.checkNotNull((Object)annotation, (Object)"annotation")).message();
    }

    public boolean isValid(final InternalProject value, ConstraintValidatorContext context) {
        if (value == null || this.projectService == null || this.securityService == null) {
            return true;
        }
        if (value.getName() == null) {
            return false;
        }
        Project found = (Project)this.securityService.doWithPermission("validate project name uniqueness", Permission.PROJECT_VIEW, (Operation)new UncheckedOperation<Project>(){

            public Project perform() throws RuntimeException {
                return ProjectNameValidator.this.projectService.getByName(value.getName());
            }
        });
        if (found == null || ObjectUtils.equals((Object)found.getId(), (Object)value.getId())) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(this.message);
        builder.addNode("name");
        builder.addConstraintViolation();
        return false;
    }

    @Override
    @Autowired
    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Override
    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

