/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalDetailedUser
implements DetailedUser {
    private final InternalStashUser delegate;
    private final String directoryName;
    private final boolean mutableDetails;
    private final boolean mutableGroups;

    private InternalDetailedUser(InternalStashUser delegate, String directoryName, boolean mutableDetails, boolean mutableGroups) {
        this.delegate = delegate;
        this.directoryName = directoryName;
        this.mutableDetails = mutableDetails;
        this.mutableGroups = mutableGroups;
    }

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }

    public InternalStashUser getDelegate() {
        return this.delegate;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getEmailAddress() {
        return this.delegate.getEmailAddress();
    }

    public Integer getId() {
        return this.delegate.getId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    @Nonnull
    public String getSlug() {
        return this.delegate.getSlug();
    }

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isMutableDetails() {
        return this.mutableDetails;
    }

    public boolean isMutableGroups() {
        return this.mutableGroups;
    }

    public static class Builder {
        private InternalStashUser delegate;
        private String directoryName;
        private boolean mutableDetails;
        private boolean mutableGroups;

        public Builder(InternalStashUser user) {
            this.delegate = (InternalStashUser)Preconditions.checkNotNull((Object)user, (Object)"user");
        }

        public Builder(InternalDetailedUser user) {
            this.delegate = ((InternalDetailedUser)Preconditions.checkNotNull((Object)user, (Object)"user")).delegate;
            this.directoryName = user.getDirectoryName();
            this.mutableDetails = user.isMutableDetails();
            this.mutableGroups = user.isMutableGroups();
        }

        public InternalDetailedUser build() {
            return new InternalDetailedUser(this.delegate, this.directoryName, this.mutableDetails, this.mutableGroups);
        }

        public Builder directoryName(String value) {
            this.directoryName = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public Builder mutableDetails(boolean value) {
            this.mutableDetails = value;
            return this;
        }

        public Builder mutableGroups(boolean value) {
            this.mutableGroups = value;
            return this;
        }
    }
}

