/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.user.DetailedGroup;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class InternalDetailedGroup
implements DetailedGroup {
    private final boolean deletable;
    private final String name;

    private InternalDetailedGroup(String name, boolean deletable) {
        this.name = name;
        this.deletable = deletable;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public static class Builder {
        private boolean deletable;
        private String name;

        public Builder() {
        }

        public Builder(InternalDetailedGroup group) {
            this.deletable = group.isDeletable();
            this.name = group.getName();
        }

        public InternalDetailedGroup build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"A group name is required");
            return new InternalDetailedGroup(this.name, this.deletable);
        }

        public Builder deletable(boolean value) {
            this.deletable = value;
            return this;
        }

        public Builder name(String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"value")).trim().isEmpty() ? 1 : 0) != 0, (Object)"The value may not be blank or empty");
            this.name = value;
            return this;
        }
    }
}

