/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sta_repo_settings", uniqueConstraints={@UniqueConstraint(name="uq_sta_repo_settings_key", columnNames={"repo_id", "setting_key"})})
public class InternalRepositorySettings {
    private static final String ID_GEN = "repositorySettingsIdGenerator";
    static final String TABLE = "sta_repo_settings";
    public static final int MAXIMUM_SETTINGS_LENGTH = 32768;
    public static final Function<InternalRepositorySettings, String> TO_KEY = new Function<InternalRepositorySettings, String>(){

        public String apply(InternalRepositorySettings settings) {
            return settings.getKey();
        }
    };
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="repositorySettingsIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_repo_settings", name="repositorySettingsIdGenerator", table="id_sequence")
    private final Long id;
    @JoinColumn(name="repo_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;
    @Column(name="setting_key")
    @RequiredString(size=255)
    private final String key;
    @Column(name="setting_data", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    @RequiredString(size=32768)
    private final String data;

    protected InternalRepositorySettings() {
        this.id = null;
        this.repository = null;
        this.key = null;
        this.data = null;
    }

    protected InternalRepositorySettings(Long id, InternalRepository repository, String key, String data) {
        this.id = id;
        this.repository = repository;
        this.key = key;
        this.data = data;
    }

    public Long getId() {
        return this.id;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public String getKey() {
        return this.key;
    }

    public String getData() {
        return this.data;
    }

    public static class Builder {
        private Long id;
        private String key;
        private InternalRepository repo;
        private String data;

        public Builder() {
        }

        public Builder(InternalRepositorySettings settings) {
            this.id = settings.getId();
            this.key = settings.getKey();
            this.repo = settings.getRepository();
            this.data = settings.getData();
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder repo(InternalRepository repo) {
            this.repo = repo;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public InternalRepositorySettings build() {
            return new InternalRepositorySettings(this.id, this.repo, this.key, this.data);
        }
    }
}

