/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRole;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@javax.persistence.Table(name="sta_pr_participant", uniqueConstraints={@UniqueConstraint(name="uq_sta_pr_participant_pr_user", columnNames={"pr_id", "user_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(appliesTo="sta_pr_participant", indexes={@Index(name="idx_sta_pr_participant_pr", columnNames={"pr_id"}), @Index(name="idx_sta_pr_participant_user", columnNames={"user_id"})})
public class InternalPullRequestParticipant
implements PullRequestParticipant {
    public static final String ID_GEN = "pullRequestIdGenerator";
    public static final String TABLE = "sta_pr_participant";
    @Column(name="pr_approved", nullable=false)
    private final boolean approved;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_pr_participant", name="pullRequestIdGenerator", table="id_sequence")
    private final Long id;
    @ForeignKey(name="fk_sta_pr_participant_pr")
    @JoinColumn(name="pr_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;
    @Column(name="pr_role", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestRole")})
    private final PullRequestRole role;
    @ForeignKey(name="fk_sta_pr_participant_user")
    @JoinColumn(name="user_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalStashUser user;

    protected InternalPullRequestParticipant() {
        this.id = null;
        this.pullRequest = null;
        this.role = null;
        this.user = null;
        this.approved = false;
    }

    private InternalPullRequestParticipant(Long id, InternalPullRequest pullRequest, PullRequestRole role, InternalStashUser user, boolean approved) {
        this.id = id;
        this.pullRequest = pullRequest;
        this.role = role;
        this.user = user;
        this.approved = approved;
    }

    public Long getId() {
        return this.id;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public InternalStashUser getUser() {
        return this.user;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public static InternalPullRequestParticipant initialize(InternalPullRequestParticipant participant) {
        if (participant != null) {
            participant.initialize();
        }
        return participant;
    }

    private void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
        Hibernate.initialize((Object)this.getUser());
    }

    public static class Builder {
        private boolean approved;
        private Long id;
        private InternalPullRequest pullRequest;
        private PullRequestRole role;
        private InternalStashUser user;

        public Builder() {
        }

        public Builder(InternalPullRequestParticipant participant) {
            this.id = participant.getId();
            this.pullRequest = participant.getPullRequest();
            this.role = participant.getRole();
            this.user = participant.getUser();
            this.approved = participant.isApproved();
        }

        public Builder approved(boolean value) {
            this.approved = value;
            return this;
        }

        public InternalPullRequestParticipant build() {
            return new InternalPullRequestParticipant(this.id, this.pullRequest, this.role, this.user, this.approved);
        }

        public Builder id(Long value) {
            this.id = value;
            return this;
        }

        public Builder pullRequest(InternalPullRequest value) {
            this.pullRequest = value;
            return this;
        }

        public Builder role(PullRequestRole value) {
            this.role = value;
            return this;
        }

        public Builder user(InternalStashUser value) {
            this.user = value;
            return this;
        }
    }
}

