/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.pull.PullRequestDiffCommentAnchor;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@DiscriminatorValue(value="1")
@Entity
@PrimaryKeyJoinColumn(name="anchor_id", referencedColumnName="id")
@javax.persistence.Table(name="sta_pr_diff_comment_anchor")
@Table(appliesTo="sta_pr_diff_comment_anchor", indexes={@Index(name="idx_sta_pr_diff_com_anc_pr", columnNames={"pr_id", "is_orphaned"})})
public class InternalPullRequestDiffCommentAnchor
extends InternalDiffCommentAnchor
implements PullRequestDiffCommentAnchor {
    public static final String TABLE = "sta_pr_diff_comment_anchor";
    @Column(name="is_orphaned", nullable=false)
    private final boolean orphaned;
    @JoinColumn(name="pr_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @ForeignKey(name="fk_sta_pr_diff_com_anc_pr")
    private final InternalPullRequest pullRequest;

    protected InternalPullRequestDiffCommentAnchor() {
        this.orphaned = false;
        this.pullRequest = null;
    }

    private InternalPullRequestDiffCommentAnchor(Long id, int version, InternalComment comment, String path, String toHash, String srcPath, String fromHash, int line, DiffSegmentType lineType, boolean orphaned, InternalPullRequest pullRequest) {
        super(id, version, comment, path, toHash, srcPath, fromHash, line, lineType);
        this.orphaned = orphaned;
        this.pullRequest = pullRequest;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getPullRequest());
    }

    public boolean isOrphaned() {
        return this.orphaned;
    }

    public static class Builder
    extends InternalDiffCommentAnchor.AbstractBuilder<Builder> {
        private boolean orphaned;
        private InternalPullRequest pullRequest;

        public Builder() {
        }

        public Builder(InternalPullRequestDiffCommentAnchor anchor) {
            super(anchor);
            this.orphaned = anchor.isOrphaned();
            this.pullRequest = anchor.getPullRequest();
        }

        public InternalPullRequestDiffCommentAnchor build() {
            return new InternalPullRequestDiffCommentAnchor(this.id, this.version, this.comment, this.path, this.toHash, this.srcPath, this.fromHash, this.line, this.lineType, this.orphaned, this.pullRequest);
        }

        public Builder orphaned(boolean value) {
            this.orphaned = value;
            return this.self();
        }

        public Builder pullRequest(InternalPullRequest value) {
            this.pullRequest = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

