/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.content.Diff;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestCommentActivity;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="2")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id")
@javax.persistence.Table(name="sta_pr_comment_activity")
@Table(appliesTo="sta_pr_comment_activity", indexes={@Index(name="idx_sta_pr_com_act_anchor", columnNames={"anchor_id"}), @Index(name="idx_sta_pr_com_act_comment", columnNames={"comment_id"})})
public class InternalPullRequestCommentActivity
extends InternalPullRequestActivity
implements PullRequestCommentActivity {
    public static final String TABLE = "sta_pr_comment_activity";
    @ForeignKey(name="fk_sta_pr_com_act_comment")
    @JoinColumn(name="comment_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="comment_action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.comment.CommentAction")})
    private final CommentAction commentAction;
    @ForeignKey(name="fk_sta_pr_com_act_anchor")
    @JoinColumn(name="anchor_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalPullRequestDiffCommentAnchor commentAnchor;
    @Transient
    private Diff diff;

    protected InternalPullRequestCommentActivity() {
        this.comment = null;
        this.commentAction = null;
        this.commentAnchor = null;
    }

    private InternalPullRequestCommentActivity(Long id, Date createdDate, InternalStashUser user, PullRequestAction action, InternalPullRequest pullRequest, InternalComment comment, CommentAction commentAction, InternalPullRequestDiffCommentAnchor commentAnchor) {
        super(id, createdDate, user, action, pullRequest);
        this.comment = comment;
        this.commentAction = commentAction;
        this.commentAnchor = commentAnchor;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestCommentActivity)this);
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    public InternalPullRequestDiffCommentAnchor getCommentAnchor() {
        return this.commentAnchor;
    }

    public Diff getDiff() {
        return this.diff;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getComment());
        HibernateUtils.initialize(this.getCommentAnchor());
    }

    public void setDiff(Diff value) {
        if (this.diff != null) {
            throw new IllegalStateException("You cannot set the diff after it's been initialized");
        }
        this.diff = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder> {
        private InternalComment comment;
        private CommentAction commentAction;
        private InternalPullRequestDiffCommentAnchor commentAnchor;

        public Builder() {
            this.action(PullRequestAction.COMMENTED);
        }

        public Builder(InternalPullRequestCommentActivity activity) {
            super(activity);
        }

        public InternalPullRequestCommentActivity build() {
            return new InternalPullRequestCommentActivity(this.id, this.createdDate, this.user, this.action, this.pullRequest, this.comment, this.commentAction, this.commentAnchor);
        }

        public Builder comment(InternalComment value) {
            this.comment = value;
            return this.self();
        }

        public Builder commentAction(CommentAction value) {
            this.commentAction = value;
            return this.self();
        }

        public Builder commentAnchor(InternalPullRequestDiffCommentAnchor value) {
            this.commentAnchor = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

