/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivity;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.Hibernate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="1")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="id")
@javax.persistence.Table(name="sta_pr_activity")
@Table(appliesTo="sta_pr_activity", indexes={@Index(name="idx_sta_pr_activity", columnNames={"pr_id", "pr_action"})})
public class InternalPullRequestActivity
extends InternalActivity
implements PullRequestActivity {
    public static final String TABLE = "sta_pr_activity";
    @Column(name="pr_action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestAction")})
    private final PullRequestAction action;
    @ForeignKey(name="fk_sta_pr_activity_pr")
    @JoinColumn(name="pr_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;

    protected InternalPullRequestActivity() {
        this.action = null;
        this.pullRequest = null;
    }

    protected InternalPullRequestActivity(Long id, Date createdDate, InternalStashUser user, PullRequestAction action, InternalPullRequest pullRequest) {
        super(id, createdDate, user);
        this.pullRequest = pullRequest;
        this.action = action;
    }

    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestActivity)this);
    }

    @Nonnull
    public PullRequestAction getAction() {
        return this.action;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
        Hibernate.initialize((Object)this.getUser());
    }

    protected static abstract class AbstractPullRequestActivityBuilder<B extends InternalActivity.AbstractActivityBuilder<B>>
    extends InternalActivity.AbstractActivityBuilder<B> {
        protected PullRequestAction action;
        protected InternalPullRequest pullRequest;

        public AbstractPullRequestActivityBuilder() {
        }

        public AbstractPullRequestActivityBuilder(InternalPullRequestActivity activity) {
            super(activity);
            this.action = activity.getAction();
            this.pullRequest = activity.getPullRequest();
        }

        public B action(PullRequestAction value) {
            this.action = value;
            return this.self();
        }

        public B pullRequest(InternalPullRequest value) {
            this.pullRequest = value;
            return this.self();
        }
    }

    public static class Builder
    extends AbstractPullRequestActivityBuilder<Builder> {
        public Builder() {
        }

        public Builder(InternalPullRequestActivity activity) {
            super(activity);
        }

        public InternalPullRequestActivity build() {
            return new InternalPullRequestActivity(this.id, this.createdDate, this.user, this.action, this.pullRequest);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

