/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryScoped;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.watcher.WatchableVisitor;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Cacheable
@Entity
@javax.persistence.Table(name="sta_pull_request")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(appliesTo="sta_pull_request", indexes={@Index(name="idx_sta_pull_request_from", columnNames={"from_repository_id", "from_branch_fqn"}), @Index(name="idx_sta_pull_request_state", columnNames={"pr_state"}), @Index(name="idx_sta_pull_request_to", columnNames={"to_repository_id", "to_branch_fqn"})})
public class InternalPullRequest
implements Initializable,
PullRequest,
RepositoryScoped {
    public static final String ID_GEN = "pullRequestIdGenerator";
    public static final String TABLE = "sta_pull_request";
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="description")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String description;
    @AssociationOverrides(value={@AssociationOverride(name="repository", joinColumns={@JoinColumn(name="from_repository_id", nullable=false)})})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="from_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="from_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="from_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef fromRef;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_pull_request", name="pullRequestIdGenerator", table="id_sequence")
    private final Long id;
    @OneToMany(mappedBy="pullRequest", targetEntity=InternalPullRequestParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final Set<PullRequestParticipant> participants;
    @Column(name="scoped_id", nullable=false)
    private Long scopedId;
    @Column(name="pr_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestState")})
    private final PullRequestState state;
    @Column(name="title", nullable=false)
    private final String title;
    @AssociationOverrides(value={@AssociationOverride(name="repository", joinColumns={@JoinColumn(name="to_repository_id", nullable=false)})})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="to_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="to_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="to_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef toRef;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @JoinColumn(name="watchable_id", updatable=false)
    @OneToMany(targetEntity=InternalWatcher.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    @Where(clause="watchable_type = 1")
    private final Set<InternalWatcher> watchers;

    public InternalPullRequest() {
        this.updatedDate = null;
        this.createdDate = null;
        this.title = null;
        this.description = null;
        this.toRef = null;
        this.fromRef = null;
        this.scopedId = null;
        this.id = null;
        this.participants = Sets.newHashSet();
        this.state = null;
        this.version = 0;
        this.watchers = Sets.newHashSet();
    }

    public InternalPullRequest(Long id, int version, Long scopedId, InternalPullRequestRef fromRef, InternalPullRequestRef toRef, String title, String description, PullRequestState state, Date createdDate, Date updatedDate, Set<PullRequestParticipant> participants, Set<InternalWatcher> watchers) {
        this.createdDate = createdDate;
        this.description = description;
        this.fromRef = fromRef;
        this.id = id;
        this.participants = participants;
        this.scopedId = scopedId;
        this.state = state;
        this.title = title;
        this.toRef = toRef;
        this.updatedDate = updatedDate;
        this.version = version;
        this.watchers = watchers;
    }

    public void accept(@Nonnull WatchableVisitor visitor) {
        visitor.visit((PullRequest)this);
    }

    @Nonnull
    public PullRequestParticipant getAuthor() {
        Set<PullRequestParticipant> authors = this.getParticipantsFilteredByRole(PullRequestRole.AUTHOR);
        if (authors.isEmpty()) {
            throw new IllegalStateException("Pull request author could not be found in pull request participants");
        }
        if (authors.size() > 1) {
            throw new IllegalStateException("Pull request has more than one author");
        }
        return (PullRequestParticipant)Iterables.getFirst(authors, null);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public InternalPullRequestRef getFromRef() {
        return this.fromRef;
    }

    public Long getGlobalId() {
        return this.id;
    }

    public Long getId() {
        return this.getScopedId();
    }

    public Set<PullRequestParticipant> getAllParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    @Nonnull
    public Set<PullRequestParticipant> getParticipants() {
        return this.getParticipantsFilteredByRole(PullRequestRole.PARTICIPANT);
    }

    @Nonnull
    public Set<PullRequestParticipant> getReviewers() {
        return this.getParticipantsFilteredByRole(PullRequestRole.REVIEWER);
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getToRef().getRepository();
    }

    @Override
    @Nonnull
    public String getScopeType() {
        return InternalPullRequest.class.getSimpleName();
    }

    @Override
    public Long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public Set<InternalWatcher> getWatchers() {
        return Collections.unmodifiableSet(this.watchers);
    }

    @Nonnull
    public InternalPullRequestRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getFromRef());
        HibernateUtils.initialize(this.getToRef());
        Hibernate.initialize(this.getAllParticipants());
        Hibernate.initialize(this.getWatchers());
        for (PullRequestParticipant participant : this.getAllParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
        for (InternalWatcher watcher : this.getWatchers()) {
            Hibernate.initialize((Object)watcher);
            Hibernate.initialize((Object)watcher.getUser());
        }
    }

    public boolean isClosed() {
        return this.getState() != PullRequestState.OPEN;
    }

    public boolean isCrossRepository() {
        return ObjectUtils.notEqual((Object)this.getFromRef().getRepository().getId(), (Object)this.getToRef().getRepository().getId());
    }

    public boolean isOpen() {
        return this.getState() == PullRequestState.OPEN;
    }

    @Override
    public void setScopedId(long value) {
        if (this.scopedId != null) {
            throw new IllegalStateException("You cannot set the scoped ID after it's been initialized");
        }
        this.scopedId = value;
    }

    void addParticipant(InternalPullRequestParticipant participant) {
        this.participants.add(participant);
    }

    void removeParticipant(InternalPullRequestParticipant participant) {
        this.participants.remove(participant);
    }

    public void addWatcher(InternalWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(InternalWatcher watcher) {
        this.watchers.remove(watcher);
    }

    private Set<PullRequestParticipant> getParticipantsFilteredByRole(PullRequestRole role) {
        return ImmutableSet.copyOf((Collection)Sets.filter(this.getAllParticipants(), (Predicate)role.getFilter()));
    }

    public static class Builder {
        private final Set<PullRequestParticipant> participants;
        private final Set<InternalWatcher> watchers;
        private Date createdDate;
        private String description;
        private InternalPullRequestRef fromRef;
        private Long id;
        private Long scopedId;
        private PullRequestState state;
        private String title;
        private InternalPullRequestRef toRef;
        private Date updatedDate;
        private int version;

        public Builder() {
            this.participants = Sets.newHashSet();
            this.watchers = Sets.newHashSet();
        }

        public Builder(InternalPullRequest request) {
            this.createdDate = request.getCreatedDate();
            this.description = request.getDescription();
            this.fromRef = request.getFromRef();
            this.id = request.getGlobalId();
            this.participants = Sets.newHashSet(request.getAllParticipants());
            this.scopedId = request.getScopedId();
            this.state = request.getState();
            this.title = request.getTitle();
            this.toRef = request.getToRef();
            this.updatedDate = request.getUpdatedDate();
            this.version = request.getVersion();
            this.watchers = Sets.newHashSet(request.getWatchers());
        }

        public InternalPullRequest build() {
            return new InternalPullRequest(this.id, this.version, this.scopedId, this.fromRef, this.toRef, this.title, this.description, this.state, this.createdDate, this.updatedDate, this.participants, this.watchers);
        }

        public Builder createdDate(Date value) {
            this.createdDate = value;
            return this;
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder fromRef(InternalPullRequestRef value) {
            this.fromRef = value;
            return this;
        }

        public Builder globalId(Long value) {
            this.id = value;
            return this;
        }

        public Builder participant(PullRequestParticipant value) {
            if (value != null) {
                this.participants.add(value);
            }
            return this;
        }

        public Builder participants(Iterable<PullRequestParticipant> values) {
            if (values != null) {
                Iterables.addAll(this.participants, (Iterable)Iterables.filter(values, (Predicate)Predicates.notNull()));
            }
            return this;
        }

        public Builder participants(PullRequestParticipant value, PullRequestParticipant ... values) {
            this.participant(value);
            if (values != null && values.length > 0) {
                this.participants(Arrays.asList(values));
            }
            return this;
        }

        public Builder scopedId(Long value) {
            this.scopedId = value;
            return this;
        }

        public Builder state(PullRequestState value) {
            this.state = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder toRef(InternalPullRequestRef value) {
            this.toRef = value;
            return this;
        }

        public Builder updatedDate(Date value) {
            this.updatedDate = value;
            return this;
        }

        public Builder watcher(InternalWatcher value) {
            if (value != null) {
                this.watchers.add(value);
            }
            return this;
        }

        public Builder watchers(Iterable<InternalWatcher> value) {
            if (value != null) {
                Iterables.addAll(this.watchers, (Iterable)Iterables.filter(value, (Predicate)Predicates.notNull()));
            }
            return this;
        }

        public Builder watchers(InternalWatcher value, InternalWatcher ... values) {
            this.watcher(value);
            if (values != null && values.length > 0) {
                this.watchers(Arrays.asList(values));
            }
            return this;
        }
    }
}

