/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.validation.RequiredString;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="cs_attribute")
@IdClass(value=PK.class)
public class InternalChangesetAttribute {
    @Id
    @JoinColumn(name="cs_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalIndexedChangeset changeset;
    @Id
    @Column(name="att_name")
    @RequiredString(size=32)
    private final String name;
    @Id
    @Column(name="att_value")
    @RequiredString(size=1024)
    private final String value;

    protected InternalChangesetAttribute() {
        this.changeset = null;
        this.name = null;
        this.value = null;
    }

    public InternalChangesetAttribute(@Nonnull InternalIndexedChangeset changeset, @Nonnull String property, @Nonnull String value) {
        this.changeset = changeset;
        this.name = property;
        this.value = value;
    }

    @Nonnull
    public InternalIndexedChangeset getChangeset() {
        return this.changeset;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalChangesetAttribute) {
            InternalChangesetAttribute that = (InternalChangesetAttribute)o;
            return this.changeset.equals(that.changeset) && this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        int result = this.changeset != null ? this.changeset.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static class PK
    implements Serializable {
        private final String changeset;
        private final String name;
        private final String value;

        public PK() {
            this(null, null, null);
        }

        public PK(String changeset, String name, String value) {
            this.changeset = changeset;
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            if (!this.changeset.equals(pk.changeset)) {
                return false;
            }
            if (!this.name.equals(pk.name)) {
                return false;
            }
            return this.value.equals(pk.value);
        }

        public int hashCode() {
            int result = this.changeset.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }
}

