/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.comment.DiffCommentAnchor;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.atlassian.stash.validation.groups.Create;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@Cacheable
@DiscriminatorColumn(name="anchor_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@javax.persistence.Table(name="sta_diff_comment_anchor")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(appliesTo="sta_diff_comment_anchor", indexes={@Index(name="idx_sta_diff_comment_from_hash", columnNames={"from_hash"}), @Index(name="idx_sta_diff_comment_to_hash", columnNames={"to_hash"}), @Index(name="idx_sta_diff_comment_to_path", columnNames={"to_path"}), @Index(name="idx_sta_diff_comment_comment", columnNames={"comment_id"})})
public abstract class InternalDiffCommentAnchor
implements DiffCommentAnchor,
Initializable {
    public static final String ID_GEN = "diffCommentAnchorIdGenerator";
    public static final String TABLE = "sta_diff_comment_anchor";
    @JoinColumn(name="comment_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @ForeignKey(name="fk_sta_diff_comment_comment")
    private final InternalComment comment;
    @Column(name="from_hash", length=40)
    @OptionalString(minimumSize=40, size=40, groups={Create.class})
    private final String fromHash;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="diffCommentAnchorIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_diff_comment_anchor", name="diffCommentAnchorIdGenerator", table="id_sequence")
    private final Long id;
    @Column(name="line_number", nullable=false)
    private final int line;
    @Column(name="line_type")
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.content.DiffSegmentType")})
    private final DiffSegmentType lineType;
    @Column(name="to_path", nullable=false, length=1024)
    @RequiredString(size=1024, groups={Create.class})
    private final String path;
    @Column(name="from_path", length=1024)
    @OptionalString(size=1024, groups={Create.class})
    private final String srcPath;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40, groups={Create.class})
    private final String toHash;
    @Column(name="anchor_type", nullable=false)
    private final int type;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;

    protected InternalDiffCommentAnchor() {
        this.comment = null;
        this.toHash = null;
        this.srcPath = null;
        this.path = null;
        this.fromHash = null;
        this.id = null;
        this.line = 0;
        this.lineType = null;
        this.type = -1;
        this.version = 0;
    }

    protected InternalDiffCommentAnchor(Long id, int version, InternalComment comment, String path, String toHash, String srcPath, String fromHash, int line, DiffSegmentType lineType) {
        this.comment = comment;
        this.fromHash = fromHash;
        this.id = id;
        this.line = line;
        this.lineType = lineType;
        this.path = path;
        this.srcPath = srcPath;
        this.toHash = toHash;
        this.version = version;
        DiscriminatorValue value = this.getClass().getAnnotation(DiscriminatorValue.class);
        if (value == null) {
            throw new IllegalStateException("DiffCommentAnchor class [" + this.getClass().getName() + "] does not have a DiscriminatorValue annotation");
        }
        this.type = Integer.parseInt(value.value());
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    @Nullable
    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getComment());
    }

    public boolean isFileComment() {
        return this.line == 0 || this.lineType == null;
    }

    public boolean isLineComment() {
        return this.line > 0 && this.lineType != null;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected InternalComment comment;
        protected String fromHash;
        protected Long id;
        protected int line;
        protected DiffSegmentType lineType;
        protected String path;
        protected String srcPath;
        protected String toHash;
        protected int version;

        public AbstractBuilder() {
        }

        public AbstractBuilder(InternalDiffCommentAnchor anchor) {
            this.comment = anchor.getComment();
            this.fromHash = anchor.getFromHash();
            this.id = anchor.getId();
            this.line = anchor.getLine();
            this.lineType = anchor.getLineType();
            this.path = anchor.getPath();
            this.srcPath = anchor.getSrcPath();
            this.toHash = anchor.getToHash();
            this.version = anchor.getVersion();
        }

        public B comment(InternalComment value) {
            this.comment = value;
            return this.self();
        }

        public B fromHash(String value) {
            this.fromHash = value;
            return this.self();
        }

        public B id(Long value) {
            this.id = value;
            return this.self();
        }

        public B line(int line, DiffSegmentType lineType) {
            this.line = line;
            this.lineType = lineType;
            return this.self();
        }

        public B path(String value) {
            this.path = value;
            return this.self();
        }

        public B srcPath(String value) {
            this.srcPath = value;
            return this.self();
        }

        public B toHash(String value) {
            this.toHash = value;
            return this.self();
        }

        protected abstract B self();
    }
}

