/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentOperations;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@javax.persistence.Table(name="sta_comment")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(appliesTo="sta_comment", indexes={@Index(name="idx_sta_comment_author", columnNames={"author_id"}), @Index(name="idx_sta_comment_parent", columnNames={"parent_id"}), @Index(name="idx_sta_comment_root", columnNames={"root_id"})})
public class InternalComment
implements Comment,
Initializable {
    public static final String ID_GEN = "commentIdGenerator";
    public static final String TABLE = "sta_comment";
    @JoinColumn(name="author_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @ForeignKey(name="fk_sta_comment_author")
    private final InternalStashUser author;
    @OneToMany(mappedBy="parent", targetEntity=InternalComment.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final List<Comment> comments = new ArrayList<Comment>();
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commentIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_comment", name="commentIdGenerator", table="id_sequence")
    private final Long id;
    @JoinColumn(name="parent_id")
    @ManyToOne(fetch=FetchType.LAZY)
    @ForeignKey(name="fk_sta_comment_parent")
    private final InternalComment parent;
    @JoinColumn(name="root_id")
    @ManyToOne(fetch=FetchType.LAZY)
    @ForeignKey(name="fk_sta_comment_root")
    private final InternalComment root;
    @Column(name="comment_text", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String text;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @Transient
    private CommentOperations permittedOperations;

    protected InternalComment() {
        this.author = null;
        this.createdDate = null;
        this.id = null;
        this.parent = null;
        this.root = null;
        this.text = null;
        this.updatedDate = null;
        this.version = 0;
    }

    private InternalComment(Long id, int version, InternalStashUser author, Date createdDate, InternalComment parent, InternalComment root, String text, Date updatedDate) {
        this.id = id;
        this.author = author;
        this.createdDate = createdDate;
        this.parent = InternalComment.notSelf(id, parent);
        this.root = InternalComment.notSelf(id, root);
        this.text = text;
        this.updatedDate = updatedDate;
        this.version = version;
    }

    @Nonnull
    public InternalStashUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    @Nullable
    public InternalComment getParent() {
        return this.parent;
    }

    @Nonnull
    public InternalComment getRoot() {
        return this.root == null ? this : this.root;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Nullable
    public CommentOperations getPermittedOperations() {
        return this.permittedOperations;
    }

    @Override
    public void initialize() {
        Hibernate.initialize((Object)this.getAuthor());
        Hibernate.initialize(this.getComments());
        for (Comment comment : this.getComments()) {
            ((InternalComment)comment).initialize();
        }
    }

    private static InternalComment notSelf(Long id, InternalComment comment) {
        if (comment != null && !Objects.equal((Object)comment.getId(), (Object)id)) {
            return comment;
        }
        return null;
    }

    void addComment(InternalComment comment) {
        this.comments.add(comment);
    }

    void removeComment(InternalComment comment) {
        this.comments.remove(comment);
    }

    public void setPermittedOperations(CommentOperations operations) {
        if (this.permittedOperations != null) {
            throw new IllegalStateException("permittedOperations has already been set");
        }
        this.permittedOperations = operations;
    }

    public static class Builder {
        private InternalStashUser author;
        private Date createdDate;
        private Long id;
        private InternalComment parent;
        private InternalComment root;
        private String text;
        private Date updatedDate;
        private int version;

        public Builder() {
        }

        public Builder(InternalComment comment) {
            this.author = comment.getAuthor();
            this.createdDate = comment.getCreatedDate();
            this.id = comment.getId();
            this.parent = comment.getParent();
            this.root = comment.getRoot();
            this.text = comment.getText();
            this.updatedDate = comment.getUpdatedDate();
            this.version = comment.getVersion();
        }

        public Builder author(InternalStashUser value) {
            this.author = value;
            return this;
        }

        public InternalComment build() {
            if (this.root == null) {
                if (this.parent != null) {
                    this.root = this.parent.getRoot();
                }
            } else if (this.parent == null) {
                this.parent = this.root;
            } else {
                InternalComment expectedRoot = this.parent.getRoot();
                if (expectedRoot == null) {
                    expectedRoot = this.parent;
                }
                if (ObjectUtils.notEqual((Object)this.root.getId(), (Object)expectedRoot.getId())) {
                    throw new IllegalStateException("Parent comment [" + this.parent.getId() + "] belongs to root [" + expectedRoot.getId() + "], but root [" + this.root.getId() + "] was set for this comment");
                }
            }
            return new InternalComment(this.id, this.version, this.author, this.createdDate, this.parent, this.root, this.text, this.updatedDate);
        }

        public Builder createdDate(Date value) {
            this.createdDate = value;
            return this;
        }

        public Builder id(Long value) {
            this.id = value;
            return this;
        }

        public Builder parent(InternalComment value) {
            this.parent = value;
            return this;
        }

        public Builder root(InternalComment value) {
            this.root = value;
            return this;
        }

        public Builder text(String value) {
            this.text = value;
            return this;
        }

        public Builder updatedDate(Date value) {
            this.updatedDate = value;
            return this;
        }
    }
}

