/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.stash.activity.Activity;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalStashUser;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Cacheable
@DiscriminatorColumn(name="activity_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@javax.persistence.Table(name="sta_activity")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(appliesTo="sta_activity", indexes={@Index(name="idx_sta_activity_type", columnNames={"activity_type"}), @Index(name="idx_sta_activity_user", columnNames={"user_id"})})
public abstract class InternalActivity
implements Activity,
Initializable {
    public static final String ID_GEN = "activityIdGenerator";
    public static final String TABLE = "sta_activity";
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="activityIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_activity", name="activityIdGenerator", table="id_sequence")
    private final Long id;
    @Column(name="activity_type", nullable=false)
    private final int type;
    @ForeignKey(name="fk_sta_activity_user")
    @JoinColumn(name="user_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalStashUser user;

    protected InternalActivity() {
        this.createdDate = null;
        this.id = null;
        this.type = -1;
        this.user = null;
    }

    protected InternalActivity(Long id, Date createdDate, InternalStashUser user) {
        this.createdDate = createdDate;
        this.id = id;
        this.user = user;
        DiscriminatorValue value = this.getClass().getAnnotation(DiscriminatorValue.class);
        if (value == null) {
            throw new IllegalStateException("Activity class [" + this.getClass().getName() + "] does not have a DiscriminatorValue annotation");
        }
        this.type = Integer.parseInt(value.value());
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    @Nonnull
    public InternalStashUser getUser() {
        return this.user;
    }

    protected static abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B>> {
        protected Date createdDate;
        protected Long id;
        protected InternalStashUser user;

        protected AbstractActivityBuilder() {
        }

        protected AbstractActivityBuilder(InternalActivity activity) {
            this.createdDate = activity.getCreatedDate();
            this.id = activity.getId();
            this.user = activity.getUser();
        }

        public B createdDate(Date value) {
            this.createdDate = value;
            return this.self();
        }

        public B id(Long value) {
            this.id = value;
            return this.self();
        }

        public B user(InternalStashUser value) {
            this.user = value;
            return this.self();
        }

        protected abstract B self();
    }
}

