/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Table(name="stash_user")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalStashUser
implements StashUser,
Serializable {
    static final String TABLE = "stash_user";
    private static final String ID_GEN = "userIdGenerator";
    private static final long serialVersionUID = 7703287194204159444L;
    @TableGenerator(name="userIdGenerator", table="id_sequence", pkColumnValue="stash_user", allocationSize=50)
    @Id
    @GeneratedValue(generator="userIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="name", nullable=false, unique=true)
    private final String username;
    @Transient
    private volatile transient User backingCrowdUser;
    @OneToMany(mappedBy="repository", cascade={CascadeType.REMOVE})
    private Set<InternalRepositoryAccess> repositoryAccesses;

    protected InternalStashUser() {
        this.id = null;
        this.username = null;
        this.backingCrowdUser = null;
    }

    public InternalStashUser(String name) {
        this(null, name);
    }

    public InternalStashUser(Integer id, String name) {
        this(id, name, null);
    }

    public InternalStashUser(Integer id, String name, User backingCrowdUser) {
        this.id = id;
        this.username = IdentifierUtils.toLowerCase((String)name);
        this.backingCrowdUser = backingCrowdUser;
    }

    public Integer getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getName() : this.username;
    }

    public User getBackingCrowdUser() {
        return this.backingCrowdUser;
    }

    public void setBackingCrowdUser(User crowdUser) {
        if (this.backingCrowdUser != null) {
            throw new IllegalStateException("You cannot set the backing crowd user after it's been initialized");
        }
        this.backingCrowdUser = crowdUser;
    }

    public boolean isActive() {
        return this.backingCrowdUser != null && this.backingCrowdUser.isActive();
    }

    public String getDisplayName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getDisplayName() : this.username;
    }

    public String getEmailAddress() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getEmailAddress() : null;
    }

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }

    public String toString() {
        return "InternalStashUser{id=" + this.id + ", name='" + this.username + '\'' + '}';
    }

    public Builder copy() {
        return new Builder(this);
    }

    public static class Builder {
        private Integer id;
        private String name;
        private User crowdUser;

        public Builder() {
        }

        public Builder(InternalStashUser user) {
            this.id = user.getId();
            this.name = user.getName();
            this.crowdUser = user.getBackingCrowdUser();
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder crowdUser(User crowdUser) {
            this.crowdUser = crowdUser;
            return this;
        }

        public InternalStashUser build() {
            return new InternalStashUser(this.id, this.name, this.crowdUser);
        }
    }
}

