/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import org.springframework.util.ObjectUtils;

@Entity
@Table(name="repository_access")
public class InternalRepositoryAccess {
    public static final String TABLE = "repository_access";
    @EmbeddedId
    private final Key id;
    @MapsId(value="userId")
    @ManyToOne
    private final InternalStashUser user;
    @MapsId(value="repositoryId")
    @ManyToOne
    private final InternalRepository repository;
    @Column(name="last_accessed")
    private final long lastAccessed;

    private InternalRepositoryAccess() {
        this.id = new Key();
        this.user = null;
        this.repository = null;
        this.lastAccessed = 0L;
    }

    private InternalRepositoryAccess(InternalStashUser user, InternalRepository repository, Date lastAccessed) {
        Preconditions.checkNotNull((Object)user, (Object)"user must be non-null");
        Preconditions.checkNotNull((Object)repository, (Object)"repository must be non-null");
        Preconditions.checkNotNull((Object)lastAccessed, (Object)"lastAccessed must be non-null");
        this.id = new Key(user.getId(), repository.getId());
        this.user = user;
        this.repository = repository;
        this.lastAccessed = lastAccessed.getTime();
    }

    public Key getId() {
        return this.id;
    }

    public Date getLastAccessed() {
        return new Date(this.lastAccessed);
    }

    public InternalStashUser getUser() {
        return this.user;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public String toString() {
        return "InternalRepositoryAccess[id=" + this.id + ",user=" + this.getUser().getUsername() + ",repository=" + this.getRepository().getProject().getKey() + "/" + this.getRepository().getSlug() + ",last_accessed=" + this.lastAccessed + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalRepositoryAccess)) {
            return false;
        }
        InternalRepositoryAccess that = (InternalRepositoryAccess)o;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.getId());
    }

    public static class Builder {
        private InternalStashUser user;
        private InternalRepository repository;
        private Date lastAccessed;

        public Builder user(InternalStashUser user) {
            this.user = user;
            return this;
        }

        public Builder repository(InternalRepository repository) {
            this.repository = repository;
            return this;
        }

        public Builder lastAccessed(Date lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        public InternalRepositoryAccess build() {
            return new InternalRepositoryAccess(this.user, this.repository, this.lastAccessed);
        }
    }

    @Embeddable
    public static class Key
    implements Serializable {
        private final Integer userId;
        private final Integer repositoryId;

        public Key() {
            this.userId = null;
            this.repositoryId = null;
        }

        public Key(Integer userId, Integer repositoryId) {
            this.userId = userId;
            this.repositoryId = repositoryId;
        }

        @Column(name="user_id")
        public Integer getUserId() {
            return this.userId;
        }

        @Column(name="repository_id")
        public Integer getRepositoryId() {
            return this.repositoryId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return ObjectUtils.nullSafeEquals((Object)this.getUserId(), (Object)that.getUserId()) && ObjectUtils.nullSafeEquals((Object)this.getRepositoryId(), (Object)that.getRepositoryId());
        }

        public int hashCode() {
            return 31 * ObjectUtils.nullSafeHashCode((Object)this.getUserId()) + ObjectUtils.nullSafeHashCode((Object)this.getRepositoryId());
        }

        public String toString() {
            return Key.class.getSimpleName() + "[userId=" + this.userId + ",repositoryId=" + this.repositoryId + "]";
        }
    }
}

