/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.GrantedPermission;
import com.atlassian.stash.user.Permission;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.springframework.util.ObjectUtils;

@Entity
@Cacheable
@Table(name="granted_permission")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalGrantedPermission
implements GrantedPermission {
    private static final String ID_GEN = "grantedPermIdGenerator";
    static final String TABLE = "granted_permission";
    @TableGenerator(name="grantedPermIdGenerator", table="id_sequence", pkColumnValue="granted_permission", allocationSize=10)
    @Id
    @GeneratedValue(generator="grantedPermIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="perm_id", nullable=false)
    @Type(type="com.atlassian.stash.internal.hibernate.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.user.Permission")})
    private final Permission permission;
    @ManyToOne
    private final InternalProject project;
    @Column(name="group_name")
    private final String group;
    @ManyToOne
    private final InternalStashUser user;

    private InternalGrantedPermission() {
        this.id = null;
        this.permission = null;
        this.project = null;
        this.group = null;
        this.user = null;
    }

    public InternalGrantedPermission(Permission permission, InternalProject project, String group, InternalStashUser user) {
        this(null, permission, project, group, user);
    }

    private InternalGrantedPermission(Integer id, Permission permission, InternalProject project, String group, InternalStashUser user) {
        this.id = id;
        this.permission = permission;
        this.project = project;
        this.group = group == null ? null : IdentifierUtils.toLowerCase((String)group);
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public Integer getId() {
        return this.id;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    public InternalProject getProject() {
        return this.project;
    }

    public InternalStashUser getUser() {
        return this.user;
    }

    public boolean isAllowAnon() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalGrantedPermission) {
            InternalGrantedPermission that = (InternalGrantedPermission)o;
            return this.isAllowAnon() == that.isAllowAnon() && ObjectUtils.nullSafeEquals((Object)this.getPermission(), (Object)that.getPermission()) && ObjectUtils.nullSafeEquals((Object)this.getGroup(), (Object)that.getGroup()) && ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId()) && ObjectUtils.nullSafeEquals((Object)this.getProject(), (Object)that.getProject()) && ObjectUtils.nullSafeEquals((Object)this.getUser(), (Object)that.getUser());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.isAllowAnon(), this.getPermission(), this.getGroup(), this.getId(), this.getProject(), this.getUser()});
    }

    public static final class Builder {
        private String group;
        private Integer id;
        private Permission permission;
        private InternalProject project;
        private InternalStashUser user;

        public Builder() {
        }

        public Builder(InternalGrantedPermission source) {
            this.group = source.getGroup();
            this.id = source.getId();
            this.permission = source.getPermission();
            this.project = source.getProject();
            this.user = source.getUser();
        }

        public InternalGrantedPermission build() {
            return new InternalGrantedPermission(this.id, this.permission, this.project, this.group, this.user);
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder permission(Permission permission) {
            this.permission = permission;
            return this;
        }

        public Builder project(InternalProject project) {
            this.project = project;
            return this;
        }

        public Builder user(InternalStashUser user) {
            this.user = user;
            return this;
        }
    }
}

