/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.constraints.ProjectKeyUnique;
import com.atlassian.stash.internal.constraints.ProjectNameUnique;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.validation.ConstraintNature;
import java.util.Locale;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Table(name="project")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ProjectKeyUnique(payload={ConstraintNature.Conflict.class})
@ProjectNameUnique(payload={ConstraintNature.Conflict.class})
public class InternalProject
implements Project {
    private static final String ID_GEN = "projectIdGenerator";
    static final String TABLE = "project";
    @TableGenerator(name="projectIdGenerator", table="id_sequence", pkColumnValue="project", allocationSize=20)
    @Id
    @GeneratedValue(generator="projectIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="project_key", unique=true)
    private final String key;
    @Column(unique=true)
    private final String name;
    @Column
    private final String description;

    protected InternalProject() {
        this.id = null;
        this.key = null;
        this.name = null;
        this.description = null;
    }

    protected InternalProject(String key, String name, String description) {
        this(null, key, name, description);
    }

    protected InternalProject(Integer id, String key, String name, String description) {
        this.id = id;
        this.key = key == null ? null : key.trim().toUpperCase(Locale.US);
        this.name = name == null ? null : name.trim();
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalProject)) {
            return false;
        }
        InternalProject that = (InternalProject)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public String toString() {
        return "Project{id=" + this.id + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public static class Builder {
        private Integer id;
        private String key;
        private String name;
        private String description;

        public Builder() {
        }

        public Builder(Project project) {
            this.id = project.getId();
            this.key = project.getKey();
            this.name = project.getName();
            this.description = project.getDescription();
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description == null ? null : description.trim();
            return this;
        }

        public InternalProject build() {
            return new InternalProject(this.id, this.key, this.name, this.description);
        }
    }
}

