/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.validation.RequiredString;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="current_app")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalCurrentApplication {
    private static final String ID_GEN = "currentApplicationIdGenerator";
    static final String TABLE = "current_app";
    @TableGenerator(name="currentApplicationIdGenerator", table="id_sequence", pkColumnValue="current_app", allocationSize=10)
    @Id
    @GeneratedValue(generator="currentApplicationIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="application_id", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String applicationId;
    @Column(name="public_key", nullable=false)
    @Lob
    @Type(type="org.hibernate.type.PrimitiveByteArrayBlobType")
    private final byte[] publicKey;
    @Column(name="private_key", nullable=false)
    @Lob
    @Type(type="org.hibernate.type.PrimitiveByteArrayBlobType")
    private final byte[] privateKey;

    protected InternalCurrentApplication() {
        this.id = null;
        this.applicationId = null;
        this.publicKey = null;
        this.privateKey = null;
    }

    public InternalCurrentApplication(String applicationId, byte[] publicKey, byte[] privateKey) {
        this(null, applicationId, publicKey, privateKey);
    }

    private InternalCurrentApplication(Integer id, String applicationId, byte[] publicKey, byte[] privateKey) {
        this.id = id;
        this.applicationId = applicationId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Integer getId() {
        return this.id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }
}

