/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class StashUserAuthenticationToken
extends AbstractAuthenticationToken
implements StashUser {
    private final StashUser user;
    private final Collection<Permission> runWithPermissions = Sets.newHashSet();

    public StashUserAuthenticationToken(StashUser user) {
        this(user, Collections.emptySet());
    }

    public StashUserAuthenticationToken(StashUser user, Permission runWithPermission) {
        this(user, Collections.singleton(runWithPermission));
    }

    public StashUserAuthenticationToken(StashUser user, Collection<Permission> runWithPermissions) {
        super(Collections.emptyList());
        this.user = this.extractUser(user);
        if (runWithPermissions != null) {
            this.runWithPermissions.addAll(runWithPermissions);
        }
        this.setAuthenticated(true);
    }

    private StashUser extractUser(StashUser user) {
        if (user instanceof StashUserAuthenticationToken) {
            return ((StashUserAuthenticationToken)user).getPrincipal();
        }
        return user;
    }

    public Collection<Permission> getRunWithPermissions() {
        return Collections.unmodifiableCollection(this.runWithPermissions);
    }

    public Integer getId() {
        return this.user.getId();
    }

    public boolean isActive() {
        return this.user.isActive();
    }

    public String getEmailAddress() {
        return this.user.getEmailAddress();
    }

    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    public Object getCredentials() {
        return null;
    }

    public StashUser getPrincipal() {
        return this.user;
    }

    public String getName() {
        if (this.user != null) {
            return this.user.getName();
        }
        return "<anonymous>";
    }

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }
}

