/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.constraints;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.constraints.RepositoryUniqueness;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryUniquenessValidator
implements ConstraintValidator<RepositoryUniqueness, InternalRepository> {
    private RepositoryService repositoryService;
    private SecurityService securityService;
    private I18nService i18nService;

    @Autowired
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Autowired
    public void setI18nService(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void initialize(RepositoryUniqueness constraintAnnotation) {
    }

    public boolean isValid(final InternalRepository value, final ConstraintValidatorContext context) {
        if (value == null || this.repositoryService == null || this.securityService == null) {
            return true;
        }
        if (value.getProject() == null || value.getSlug() == null) {
            return false;
        }
        return (Boolean)this.securityService.doWithPermission("validate repository uniqueness", Permission.PROJECT_READ, (Operation)new Operation<Boolean, RuntimeException>(){

            public Boolean perform() throws RuntimeException {
                Repository repoBySlug = RepositoryUniquenessValidator.this.repositoryService.findRepositoryBySlug(value.getProject().getKey(), value.getSlug());
                if (repoBySlug != null && !repoBySlug.getId().equals(value.getId())) {
                    String message = RepositoryUniquenessValidator.this.i18nService.getText("com.atlassian.stash.validation.repository.unique.message", "This repository URL is already taken by ''{0}''", new Object[]{repoBySlug.getName()});
                    context.disableDefaultConstraintViolation();
                    ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(message);
                    builder.addNode("name");
                    builder.addConstraintViolation();
                    return false;
                }
                return true;
            }
        });
    }
}

