/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.constraints;

import com.atlassian.stash.internal.constraints.ProjectKeyUnique;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectKeyValidator
implements ConstraintValidator<ProjectKeyUnique, InternalProject> {
    private ProjectService projectService;
    private SecurityService securityService;

    @Autowired
    public void setProjectService(ProjectService service) {
        this.projectService = service;
    }

    @Autowired
    public void setSecurityService(SecurityService service) {
        this.securityService = service;
    }

    public void initialize(ProjectKeyUnique constraintAnnotation) {
    }

    public boolean isValid(final InternalProject value, final ConstraintValidatorContext context) {
        if (value == null || this.projectService == null || this.securityService == null) {
            return true;
        }
        if (value.getKey() == null) {
            return false;
        }
        return (Boolean)this.securityService.doWithPermission("validate project key uniqueness", Permission.PROJECT_READ, (Operation)new Operation<Boolean, RuntimeException>(){

            public Boolean perform() throws RuntimeException {
                Project projectByKey = ProjectKeyValidator.this.projectService.findByKey(value.getKey());
                if (projectByKey != null && !projectByKey.getId().equals(value.getId())) {
                    context.disableDefaultConstraintViolation();
                    ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate("{com.atlassian.stash.validation.project.key.unique.message}");
                    builder.addNode("key");
                    builder.addConstraintViolation();
                    return false;
                }
                return true;
            }
        });
    }
}

