/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalPermittedUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

public abstract class AbstractHibernateGrantedPermissionDao<E extends InternalGrantedPermission>
extends AbstractHibernateDao<Long, E>
implements GrantedPermissionDao<E> {
    public static final String FIELD_DISPLAY_NAME = "displayName";
    public static final String FIELD_USERNAME = "username";

    public AbstractHibernateGrantedPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }

    public boolean hasPermissionEntry(@Nonnull E grantedPermission) {
        Criteria criteria = this.createHasPermissionEntryCriteria(grantedPermission);
        return (Long)criteria.uniqueResult() > 0L;
    }

    protected Query createFindHighestPermissionPerGroupQuery(String filter, String additionalClause) {
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.user.InternalPermittedGroup(p.group, max(t.weight)) from " + this.entityClass.getSimpleName() + " p, InternalPermissionType t " + "where p.permission = t.id " + "and p.user is null " + "and " + (StringUtils.isNotEmpty((String)filter) ? "p.group like :filter " : "p.group is not null ") + (additionalClause != null ? "and p." + additionalClause + " " : "") + "group by p.group " + "order by p.group");
        if (StringUtils.isNotEmpty((String)filter)) {
            query.setString("filter", "%" + IdentifierUtils.toLowerCase((String)filter) + "%");
        }
        return query;
    }

    protected Query createFindHighestPermissionPerUserQuery(Page<StashUser> users, String additionalClause) {
        return this.session().createQuery("select p.user.id, max(t.weight) from " + this.entityClass.getSimpleName() + " p, InternalPermissionType t " + "where p.permission = t.id " + "and p.user.id in (:userIds) " + (additionalClause != null ? "and p." + additionalClause + " " : "") + "group by p.user.id").setParameterList("userIds", (Collection)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)users.getValues(), (Function)UserUtils.TO_ID)));
    }

    protected Criteria createHasPermissionEntryCriteria(E grantedPermission) {
        return this.session().createCriteria(this.entityClass).add((Criterion)Restrictions.eq((String)"permission", (Object)grantedPermission.getPermission())).add((Criterion)(grantedPermission.getGroup() == null ? Restrictions.isNull((String)"group") : Restrictions.eq((String)"group", (Object)IdentifierUtils.toLowerCase((String)grantedPermission.getGroup())))).add((Criterion)(grantedPermission.getUser() == null ? Restrictions.isNull((String)"user") : Restrictions.eq((String)"user", (Object)grantedPermission.getUser()))).setProjection((Projection)Projections.count((String)"id"));
    }

    protected Query createRevokeQuery(InternalGrantedPermission grantedPermission, String additionalClause) {
        Query query = this.session().createQuery("delete " + this.entityClass.getSimpleName() + " perm " + "where perm.permission = :permission " + "and " + (grantedPermission.getUser() == null ? "perm.user is null " : "perm.user = :user ") + "and " + (grantedPermission.getGroup() == null ? "perm.group is null " : "perm.group = :groupName ") + (additionalClause != null ? "and perm." + additionalClause : "")).setParameter("permission", (Object)grantedPermission.getPermission());
        if (grantedPermission.getUser() != null) {
            query.setParameter("user", (Object)grantedPermission.getUser());
        }
        if (grantedPermission.getGroup() != null) {
            query.setParameter("groupName", (Object)IdentifierUtils.toLowerCase((String)grantedPermission.getGroup()));
        }
        return query;
    }

    protected Page<String> findGroupsWithPermission(PageRequest pageRequest, Criterion ... additionalCriterion) {
        Criteria criteria = this.createCriteria().add(Restrictions.isNull((String)"user")).add(Restrictions.isNotNull((String)"group")).addOrder(Order.asc((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"group"))).setCacheable(true).setCacheRegion("query.permissions");
        for (Criterion criterion : additionalCriterion) {
            criteria.add(criterion);
        }
        return HibernatePageUtils.pageCriteria(criteria, pageRequest);
    }

    protected <T extends InternalStashUser> Page<StashUser> findUsersWithPermission(UserType userType, String filter, PageRequest pageRequest, Criterion ... additionalCriterion) {
        DetachedCriteria permissionCriteria = DetachedCriteria.forClass((Class)this.entityClass).add(Restrictions.isNotNull((String)"user")).add(Restrictions.isNull((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"user.id")));
        for (Criterion criterion : additionalCriterion) {
            permissionCriteria.add(criterion);
        }
        Criteria userCriteria = this.session().createCriteria(this.userEntityForType(userType));
        userCriteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)permissionCriteria));
        if (userType == UserType.NORMAL) {
            userCriteria.addOrder(Order.asc((String)FIELD_USERNAME));
            if (StringUtils.isNotEmpty((String)filter)) {
                userCriteria.add(Restrictions.ilike((String)FIELD_USERNAME, (String)filter, (MatchMode)MatchMode.ANYWHERE));
            }
        } else {
            userCriteria.addOrder(Order.asc((String)FIELD_DISPLAY_NAME));
            if (StringUtils.isNotEmpty((String)filter)) {
                userCriteria.add(Restrictions.ilike((String)FIELD_DISPLAY_NAME, (String)filter, (MatchMode)MatchMode.ANYWHERE));
            }
        }
        return HibernatePageUtils.pageCriteria(userCriteria, pageRequest);
    }

    private Class<? extends InternalStashUser> userEntityForType(UserType userType) {
        switch (userType) {
            case NORMAL: {
                return InternalNormalUser.class;
            }
            case SERVICE: {
                return InternalServiceUser.class;
            }
        }
        throw new IllegalArgumentException("Unexpected user type " + userType);
    }

    protected Page<PermittedUser> pairUsersWithPermissions(Page<StashUser> page, Query query) {
        List values = query.list();
        final HashMap<Integer, Integer> idToWeight = new HashMap<Integer, Integer>(values.size());
        for (Object[] objects : values) {
            idToWeight.put((Integer)objects[0], (Integer)objects[1]);
        }
        return page.transform((Function)new Function<StashUser, PermittedUser>(){

            public InternalPermittedUser apply(StashUser user) {
                Integer weight = (Integer)idToWeight.get(user.getId());
                if (weight == null) {
                    throw new IllegalStateException("No weight was found for the permission assigned to " + user.getName());
                }
                return new InternalPermittedUser(user, weight.intValue());
            }
        });
    }

    public int revokeAll(int userId) {
        return this.session().createQuery("delete " + this.entityClass.getSimpleName() + " p where p.user.id = :userId").setInteger("userId", userId).executeUpdate();
    }

    public int revokeAll(@Nonnull String groupName) {
        return this.session().createQuery("delete " + this.entityClass.getSimpleName() + " p where p.group = :groupName").setString("groupName", IdentifierUtils.toLowerCase((String)groupName)).executeUpdate();
    }
}

