/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.util.ProxyUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.ReflectionUtils;

public class TransactionAwareDataSource
extends TransactionAwareDataSourceProxy {
    public TransactionAwareDataSource(DataSource targetDataSource) {
        super(targetDataSource);
    }

    protected Connection getTransactionAwareConnectionProxy(DataSource targetDataSource) {
        return (Connection)ProxyUtils.createProxy(ConnectionProxy.class, (InvocationHandler)new ConnectionUnwrappingTransactionAwareInvocationHandler(targetDataSource), (Class[])new Class[0]);
    }

    private class ConnectionUnwrappingTransactionAwareInvocationHandler
    implements InvocationHandler {
        private final DataSource targetDataSource;
        private volatile boolean closed;
        private Connection target;

        public ConnectionUnwrappingTransactionAwareInvocationHandler(DataSource targetDataSource) {
            this.targetDataSource = targetDataSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            if ("toString".equals(method.getName())) {
                StringBuilder builder = new StringBuilder("Hibernate-unwrapping transaction-aware proxy for ");
                if (this.target == null) {
                    builder.append(" dataSource [").append(this.targetDataSource).append("]");
                } else {
                    builder.append(" connection [").append(this.target).append("]");
                }
                return builder.toString();
            }
            if ("close".equals(method.getName())) {
                DataSourceUtils.doReleaseConnection((Connection)this.target, (DataSource)this.targetDataSource);
                this.closed = true;
                return null;
            }
            if ("isClosed".equals(method.getName())) {
                return this.closed;
            }
            if ("unwrap".equals(method.getName())) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return proxy;
                }
            } else if ("isWrapperFor".equals(method.getName()) && ((Class)args[0]).isInstance(proxy)) {
                return true;
            }
            Connection actualTarget = this.getActualTarget();
            Connection invocationTarget = this.unwrap(actualTarget);
            if ("getTargetConnection".equals(method.getName())) {
                return invocationTarget;
            }
            try {
                Object value = ReflectionUtils.invokeMethod((Method)method, (Object)invocationTarget, (Object[])args);
                if (value instanceof Statement) {
                    DataSourceUtils.applyTransactionTimeout((Statement)((Statement)value), (DataSource)this.targetDataSource);
                }
                Object object = value;
                return object;
            }
            finally {
                if (actualTarget != this.target) {
                    DataSourceUtils.doReleaseConnection((Connection)actualTarget, (DataSource)this.targetDataSource);
                }
            }
        }

        private Connection getActualTarget() throws SQLException {
            Connection actualTarget;
            if (this.target == null) {
                if (this.closed) {
                    throw new SQLException("Connection handle already closed");
                }
                if (TransactionAwareDataSource.this.shouldObtainFixedConnection(this.targetDataSource)) {
                    this.target = DataSourceUtils.doGetConnection((DataSource)this.targetDataSource);
                }
            }
            if ((actualTarget = this.target) == null) {
                actualTarget = DataSourceUtils.doGetConnection((DataSource)this.targetDataSource);
            }
            return actualTarget;
        }

        private Connection unwrap(Connection connection) {
            if (connection instanceof JdbcWrapper) {
                connection = (Connection)((JdbcWrapper)connection).getWrappedObject();
            }
            return connection;
        }
    }
}

