/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.RepositoryHookDao;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryHookDao")
public class HibernateRepositoryHookDao
extends AbstractHibernateDao<Long, InternalRepositoryHook>
implements RepositoryHookDao {
    @Autowired
    public HibernateRepositoryHookDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public InternalRepositoryHook findByKey(@Nonnull InternalRepository repository, @Nonnull String hookKey) {
        return (InternalRepositoryHook)this.session().createCriteria(InternalRepositoryHook.class).add((Criterion)Restrictions.eq((String)"repository.id", (Object)repository.getId())).add((Criterion)Restrictions.eq((String)"hookKey", (Object)hookKey)).uniqueResult();
    }

    public List<InternalRepositoryHook> findByKey(@Nonnull InternalRepository repository, @Nonnull Collection<String> hookKeys) {
        return this.session().createCriteria(InternalRepositoryHook.class).add((Criterion)Restrictions.eq((String)"repository.id", (Object)repository.getId())).add(Restrictions.in((String)"hookKey", hookKeys)).list();
    }

    @Nonnull
    public List<InternalRepositoryHook> findEnabledByKey(@Nonnull InternalRepository repository, @Nonnull Collection<String> hookKeys) {
        if (CollectionUtils.isEmpty(hookKeys)) {
            return Collections.emptyList();
        }
        return this.session().createCriteria(InternalRepositoryHook.class).add((Criterion)Restrictions.eq((String)"repository.id", (Object)repository.getId())).add(Restrictions.in((String)"hookKey", hookKeys)).add((Criterion)Restrictions.eq((String)"enabled", (Object)true)).list();
    }

    @Override
    public InternalRepositoryHook update(InternalRepositoryHook entity) {
        InternalSharedLob lobToDelete = null;
        if (entity.getSettings() == null && entity.getId() != -1L) {
            lobToDelete = ((InternalRepositoryHook)this.getById(entity.getId())).getSettings();
        }
        InternalRepositoryHook updated = super.update(entity);
        if (lobToDelete != null) {
            this.session().delete(lobToDelete);
        }
        return updated;
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id").ignoreCase());
    }
}

