/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.AbstractHibernateDiffCommentAnchorDao;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorDao;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository(value="pullRequestCommentAnchorDao")
public class HibernatePullRequestCommentAnchorDao
extends AbstractHibernateDiffCommentAnchorDao<InternalPullRequest, InternalPullRequestDiffCommentAnchor>
implements PullRequestCommentAnchorDao {
    @Autowired
    public HibernatePullRequestCommentAnchorDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Map<InternalChangeLocation, CommentCounts> getCountsByLocation(@Nonnull InternalPullRequest pullRequest) {
        List results = this.session().createQuery("select path, srcPath, orphaned, count(*) from InternalPullRequestDiffCommentAnchor where pullRequest.id = :pullRequestId group by path, srcPath, orphaned order by path, srcPath").setLong("pullRequestId", pullRequest.getGlobalId().longValue()).list();
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        return HibernatePullRequestCommentAnchorDao.mapCounts(results);
    }

    @Nonnull
    public Collection<InternalPullRequestDiffCommentAnchor> findByCommentIds(@Nonnull Set<Long> commentIds) {
        if (commentIds.isEmpty()) {
            return Collections.emptyList();
        }
        Criteria criteria = this.session().createCriteria(InternalPullRequestDiffCommentAnchor.class).add(Restrictions.in((String)"comment.id", commentIds));
        return criteria.list();
    }

    @Override
    protected Criteria createAnchorCriteria(@Nonnull InternalPullRequest pullRequest, @Nonnull DiffCommentAnchorSearchCriteria searchCriteria) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestDiffCommentAnchor.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequest.getGlobalId()));
        if (searchCriteria.hasToHash()) {
            criteria.add((Criterion)Restrictions.eq((String)"toHash", (Object)searchCriteria.getToHash()));
            if (searchCriteria.hasFromHash()) {
                criteria.add((Criterion)Restrictions.eq((String)"fromHash", (Object)searchCriteria.getFromHash()));
            } else {
                criteria.add(Restrictions.isNull((String)"fromHash"));
            }
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"orphaned", (Object)false));
        }
        return criteria;
    }

    private static Map<InternalChangeLocation, CommentCounts> mapCounts(List<Object[]> results) {
        HashMap countsByLocation = Maps.newHashMapWithExpectedSize((int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            CountHelper helper = new CountHelper(results.get(i));
            int next = i + 1;
            if (next < results.size() && helper.merge(results.get(next))) {
                i = next;
            }
            countsByLocation.put(helper.getLocation(), helper.getCounts());
        }
        return countsByLocation;
    }

    private static class CountHelper {
        private final String path;
        private final String srcPath;
        private int activeCount;
        private int orphanedCount;

        private CountHelper(Object[] columns) {
            this.path = (String)columns[0];
            this.srcPath = (String)columns[1];
            this.setCountFrom(columns);
        }

        public CommentCounts getCounts() {
            return new CommentCounts(this.activeCount, this.orphanedCount);
        }

        public InternalChangeLocation getLocation() {
            return new InternalChangeLocation.Builder().path(this.path).srcPath(this.srcPath).build();
        }

        public boolean merge(Object[] columns) {
            if (this.path.equals(columns[0]) && ObjectUtils.nullSafeEquals((Object)this.srcPath, (Object)columns[1])) {
                this.setCountFrom(columns);
                return true;
            }
            return false;
        }

        public void setCountFrom(Object[] columns) {
            int count = ((Number)columns[3]).intValue();
            if (((Boolean)columns[2]).booleanValue()) {
                this.orphanedCount = count;
            } else {
                this.activeCount = count;
            }
        }
    }
}

