/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.AbstractHibernateActivityDao;
import com.atlassian.stash.internal.activity.ActivityLock;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestActivitySearchCriteria;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivityPage;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.pull.SimplePullRequestActivityPage;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.concurrent.LockGuard;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestActivityDao")
public class HibernatePullRequestActivityDao
extends AbstractHibernateActivityDao<InternalPullRequestActivity>
implements PullRequestActivityDao {
    private final int maxScanPages;
    private final int scanPageSize;

    @Autowired
    public HibernatePullRequestActivityDao(SessionFactory sessionFactory, ActivityLock activityLock, @Value(value="${page.scan.pullrequest.activity.size}") int scanPageSize, @Value(value="${page.scan.pullrequest.activity.count}") int maxScanPageCount) {
        super(sessionFactory, activityLock);
        this.maxScanPages = maxScanPageCount;
        this.scanPageSize = scanPageSize;
    }

    @Nonnull
    public Map<Long, Long> countCommentsByPullRequest(@Nonnull Set<Long> pullRequestIds) {
        if (pullRequestIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("select a.pullRequest.id, count(*) from InternalPullRequestCommentActivity a where a.pullRequest.id in (:pullRequestIds) and a.commentAction in (:actions) group by a.pullRequest.id").setParameterList("pullRequestIds", pullRequestIds).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED)).list();
        HashMap<Long, Long> counts = new HashMap<Long, Long>(results.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            counts.put((Long)columns[0], (Long)columns[1]);
        }
        return counts;
    }

    public int deleteByComment(long commentId) {
        try (LockGuard ignored = this.activityLock.forDelete();){
            int n = this.session().createQuery("delete from InternalPullRequestCommentActivity where comment.id = :commentId").setLong("commentId", commentId).executeUpdate();
            return n;
        }
    }

    public int deleteByPullRequest(long pullRequestId) {
        return this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id = :pullRequestId", (Map<String, Object>)ImmutableMap.of((Object)"pullRequestId", (Object)pullRequestId));
    }

    public int deleteByRepository(int repositoryId) {
        return this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id in (select id from InternalPullRequest where toRef.repository.id = :repositoryId)", (Map<String, Object>)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId));
    }

    public int deleteEmptyRescopes() {
        return this.maybeBulkDelete("from InternalPullRequestRescopeActivity where totalAdded != null and totalRemoved != null and totalAdded = 0 and totalRemoved = 0");
    }

    public InternalPullRequestCommentActivity findByComment(long pullRequestId, long commentId) {
        return (InternalPullRequestCommentActivity)HibernateUtils.initialize((Object)((InternalPullRequestCommentActivity)this.session().createCriteria(InternalPullRequestCommentActivity.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId)).add((Criterion)Restrictions.eq((String)"comment.id", (Object)commentId)).add((Criterion)Restrictions.eq((String)"commentAction", (Object)CommentAction.ADDED)).uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequestActivity> findByPullRequest(long pullRequestId, @Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage(this.getPageOfActivities(pullRequestId, pageRequest));
    }

    @Nonnull
    public List<Long> findCalculableRescopes() {
        return this.session().createCriteria(InternalPullRequestRescopeActivity.class).createAlias("pullRequest", "pr").add(Restrictions.isNull((String)"totalAdded")).add((Criterion)Restrictions.eq((String)"pr.state", (Object)PullRequestState.OPEN)).setProjection((Projection)Projections.id()).list();
    }

    @Nonnull
    public PullRequestActivityPage<InternalPullRequestActivity> findPageStartingAt(long pullRequestId, long activityId, @Nonnull PageRequest pageRequest) {
        if (pageRequest.getLimit() > this.scanPageSize) {
            throw new IllegalArgumentException("Page limit is too large. It must be less than " + this.scanPageSize);
        }
        InternalPullRequestActivity targetActivity = this.getById(activityId);
        if (targetActivity != null) {
            final InternalPullRequest pullRequest = targetActivity.getPullRequest();
            if (pullRequest.getGlobalId() != pullRequestId) {
                throw new IllegalArgumentException("The pull request supplied does not match the pull request of the activity");
            }
            Iterator activities = new PagedIterable((PageProvider)new PageProvider<InternalPullRequestActivity>(){

                public Page<InternalPullRequestActivity> get(PageRequest request) {
                    if (request.getStart() > HibernatePullRequestActivityDao.this.maxScanPages * HibernatePullRequestActivityDao.this.scanPageSize) {
                        return PageUtils.createEmptyPage((PageRequest)request);
                    }
                    return HibernatePullRequestActivityDao.this.getPageOfActivities(pullRequest.getGlobalId(), request);
                }
            }, PageUtils.newRequest((int)0, (int)this.scanPageSize)).iterator();
            ArrayDeque<InternalPullRequestActivity> activityWindow = new ArrayDeque<InternalPullRequestActivity>(pageRequest.getLimit());
            int activityCount = 0;
            Long noId = -1L;
            while (activities.hasNext()) {
                InternalPullRequestActivity activity = (InternalPullRequestActivity)activities.next();
                if (activity.getId() == activityId) {
                    ArrayList page = Lists.newArrayListWithCapacity((int)pageRequest.getLimit());
                    int start = activityCount;
                    if (activityWindow.size() < pageRequest.getLimit()) {
                        start = 0;
                        page.addAll(activityWindow);
                    }
                    page.add(activity);
                    Iterators.addAll((Collection)page, (Iterator)Iterators.limit((Iterator)activities, (int)(pageRequest.getLimit() - page.size())));
                    boolean isLastPage = !activities.hasNext();
                    Long previousStartId = start == 0 ? noId : ((InternalPullRequestActivity)activityWindow.peekFirst()).getId();
                    return new SimplePullRequestActivityPage(PageUtils.createPage((Iterable)HibernateUtils.initializeList((List)page), (boolean)isLastPage, (PageRequest)PageUtils.newRequest((int)start, (int)pageRequest.getLimit())), previousStartId.longValue());
                }
                if (activityWindow.size() == pageRequest.getLimit()) {
                    activityWindow.pollFirst();
                }
                activityWindow.add(activity);
                ++activityCount;
            }
        }
        return new SimplePullRequestActivityPage(PageUtils.createEmptyPage((PageRequest)pageRequest), -1L);
    }

    @Nonnull
    public Set<InternalStashUser> findUsersWithActivities(long pullRequestId, @Nonnull Set<PullRequestAction> includedActions, @Nonnull Set<PullRequestAction> excludedActions) {
        EnumSet actions = includedActions.isEmpty() ? Sets.complementOf(excludedActions, PullRequestAction.class) : Sets.difference(includedActions, excludedActions);
        Query query = this.session().createQuery("select distinct(activity.user) from InternalPullRequestActivity activity where activity.pullRequest.id = :pullRequestId and activity.action in (:actions)").setLong("pullRequestId", pullRequestId).setParameterList("actions", (Collection)actions);
        return Sets.newHashSet((Iterable)query.list());
    }

    @Override
    public InternalPullRequestActivity getById(Long id) {
        return (InternalPullRequestActivity)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalPullRequestActivity> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    @Nonnull
    public Page<InternalPullRequestActivity> search(final PullRequestActivitySearchCriteria searchCriteria, PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestActivity.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)searchCriteria.getPullRequestId())).add((Criterion)Restrictions.or((Criterion[])((Criterion[])Iterables.toArray((Iterable)Collections2.transform((Collection)searchCriteria.getTypes(), (Function)new Function<Integer, Criterion>(){

            public Criterion apply(Integer type) {
                SimpleExpression typeClause = Restrictions.eq((String)"type", (Object)type);
                if (type == 2) {
                    Conjunction expandedTypeClause = Restrictions.and((Criterion[])new Criterion[]{typeClause});
                    if (CollectionUtils.isNotEmpty((Collection)searchCriteria.getCommentActions())) {
                        expandedTypeClause.add(Restrictions.in((String)"commentAction", (Collection)searchCriteria.getCommentActions()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)searchCriteria.getCommentIds())) {
                        expandedTypeClause.add(Restrictions.in((String)"comment.id", (Collection)searchCriteria.getCommentIds()));
                    }
                    typeClause = expandedTypeClause;
                }
                return typeClause;
            }
        }), Criterion.class))));
        return HibernateUtils.initializePage(this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest));
    }

    private Page<InternalPullRequestActivity> getPageOfActivities(long pullRequestId, PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestActivity.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId));
        criteria.add(Restrictions.not((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)1), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"action", (Object)PullRequestAction.RESCOPED), (Criterion)Restrictions.eq((String)"action", (Object)PullRequestAction.UPDATED))), Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)2), (Criterion)Restrictions.ne((String)"commentAction", (Object)CommentAction.ADDED)), Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"type", (Object)4), Restrictions.isNotNull((String)"totalAdded"), Restrictions.isNotNull((String)"totalRemoved"), Restrictions.eq((String)"totalAdded", (Object)0), Restrictions.eq((String)"totalRemoved", (Object)0)})})));
        return this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest);
    }
}

