/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectSearchRequest;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="projectDao")
public class HibernateProjectDao
extends AbstractHibernateDao<Integer, InternalProject>
implements ProjectDao {
    private static final Function<Project, String> TO_KEY = new Function<Project, String>(){

        public String apply(Project project) {
            return project.getKey();
        }
    };

    @Autowired
    public HibernateProjectDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countAll() {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalProject.class));
    }

    public InternalPersonalProject createPersonal(@Nonnull InternalPersonalProject project) {
        this.create(project);
        return project;
    }

    @Override
    @Nonnull
    public Page<InternalProject> findAll(PageRequest pageRequest) {
        return this.findAll(pageRequest, (Predicate<? super InternalProject>)null);
    }

    @Override
    @Nonnull
    public Page<InternalProject> findAll(PageRequest pageRequest, Predicate<? super InternalProject> predicate) {
        Criteria criteria = this.createBaseCriteria();
        if (predicate == null) {
            return this.pageCriteria(criteria, pageRequest);
        }
        return this.pageCriteria(criteria, pageRequest, predicate);
    }

    @Nonnull
    public Iterable<String> findAllKeys(@Nonnull Predicate<? super InternalProject> predicate) {
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.project.ProjectIdKeyWrapper(p.id, p.key, p.publiclyAccessible) from InternalNormalProject p order by p.key");
        return Chainable.chain((Iterable)query.list()).filter(predicate).transform(TO_KEY);
    }

    @Override
    public InternalProject getById(Integer id) {
        return (InternalProject)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalProject> getByIds(@Nonnull Collection<Integer> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    public InternalProject getByKey(@Nonnull String key) {
        return (InternalProject)HibernateUtils.initialize((Object)((InternalProject)this.session().createQuery("from InternalProject where upper(key) = upper(:projectKey)").setParameter("projectKey", (Object)key).setCacheable(true).setCacheRegion("query.projects").uniqueResult()));
    }

    public InternalProject getByName(@Nonnull String name) {
        return (InternalProject)HibernateUtils.initialize((Object)((InternalProject)this.session().createQuery("from InternalProject where upper(name) = upper(:name)").setParameter("name", (Object)name).uniqueResult()));
    }

    public InternalPersonalProject getByOwner(int ownerId) {
        return (InternalPersonalProject)HibernateUtils.initialize((Object)((InternalPersonalProject)this.session().createCriteria(InternalPersonalProject.class).add((Criterion)Restrictions.eq((String)"owner.id", (Object)ownerId)).uniqueResult()));
    }

    public InternalPersonalProject getByUsername(String username) {
        return (InternalPersonalProject)HibernateUtils.initialize((Object)((InternalPersonalProject)this.session().createCriteria(InternalPersonalProject.class).createAlias("owner", "o").add((Criterion)Restrictions.eq((String)"o.username", (Object)IdentifierUtils.toLowerCase((String)username))).uniqueResult()));
    }

    public boolean hasRepositories(int projectId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId))) != 0L;
    }

    @Nonnull
    public Page<InternalProject> search(@Nonnull ProjectSearchRequest searchRequest, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalProject> predicate) {
        Criteria criteria = this.createBaseCriteria();
        if (searchRequest.hasName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)searchRequest.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return this.pageCriteria(criteria, pageRequest, predicate);
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"name").ignoreCase());
    }

    private Criteria createBaseCriteria() {
        return this.applyImplicitOrder(this.session().createCriteria(InternalNormalProject.class));
    }
}

