/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pluginSettingDao")
public class HibernatePluginSettingDao
implements PluginSettingDao {
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernatePluginSettingDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    public void put(String namespace, String key, String val) {
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        PluginSetting setting = this.getByKey(namespace, key);
        if (setting == null) {
            setting = new PluginSetting.Builder().key(key).namespace(namespace).value(val).build();
            this.session().saveOrUpdate((Object)setting);
        } else if (!Objects.equals(setting.getValue(), val)) {
            setting = new PluginSetting.Builder(setting).value(val).build();
            this.session().merge((Object)setting);
        }
    }

    public String get(String namespace, String key) {
        if (namespace == null || key == null) {
            return null;
        }
        PluginSetting result = this.getByKey(namespace, key);
        return result == null ? null : result.getValue();
    }

    public void remove(String namespace, String key) {
        if (namespace == null || key == null) {
            return;
        }
        PluginSetting setting = this.getByKey(namespace, key);
        if (setting != null) {
            this.session().delete((Object)setting);
        }
    }

    private PluginSetting getByKey(String namespace, String key) {
        try {
            return (PluginSetting)this.session().createCriteria(PluginSetting.class).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).add((Criterion)Restrictions.eq((String)"key", (Object)key)).uniqueResult();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }
}

