/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SetStashUserSlugChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private static final SecureTokenGenerator GENERATOR = DefaultSecureTokenGenerator.getInstance();
    private static final Logger log = LoggerFactory.getLogger(SetStashUserSlugChange.class);

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        try {
            final LinkedHashMap needingNewSlug = Maps.newLinkedHashMap();
            template.query("select id, name from stash_user order by id", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    int id = rs.getInt(1);
                    String name = rs.getString(2);
                    if (name.length() > 126 || !InternalNormalUser.slugify((String)name).equals(name)) {
                        needingNewSlug.put(id, name);
                    }
                }
            });
            log.debug("Found {} users requiring a slug other than their username", (Object)needingNewSlug.size());
            block2: for (Map.Entry<Integer, String> entry : needingNewSlug.entrySet()) {
                String initialSlug;
                String slug = initialSlug = InternalNormalUser.slugify((String)((String)entry.getValue()));
                for (int retries = 0; retries <= 10; ++retries) {
                    if (this.isSlugFree(template, slug)) {
                        log.debug("Found available slug \"{}\" for stash_user with ID {} and name \"{}\"", new Object[]{slug, entry.getKey(), entry.getValue()});
                        this.updateSlug(template, entry, slug);
                        continue block2;
                    }
                    log.debug("Collision detected for slug \"{}\" for stash_user with ID {} and name \"{}\"", new Object[]{slug, entry.getKey(), entry.getValue()});
                    slug = initialSlug + retries;
                }
                slug = InternalNormalUser.generateSlug((SecureTokenGenerator)GENERATOR);
                log.debug("Using random token slug \"{}\" for stash_user with ID {} and name \"{}\".", new Object[]{slug, entry.getKey(), entry.getValue()});
                this.updateSlug(template, entry, slug);
            }
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Failed to initialise all slug values on stash_user", (Throwable)e);
        }
    }

    private boolean isSlugFree(JdbcTemplate template, String slug) {
        return template.queryForInt("select count(id) from stash_user where slug = ?", new Object[]{slug}) == 0;
    }

    public void rollback(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        try {
            template.update("update stash_user set slug = name");
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Could not rollback generation of slug values for stash_user table", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return "All stash_user slug values were set";
    }

    private int updateSlug(JdbcTemplate template, Map.Entry<Integer, String> idAndName, String slug) {
        return template.update("update stash_user set slug = ? where id = ?", new Object[]{slug, idAndName.getKey()});
    }
}

