/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate.dialect.resolver;

import com.atlassian.stash.internal.hibernate.dialect.CustomMySqlDialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres81Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres82Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres9Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2005Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2008Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2012Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServerDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDialectResolver
implements DialectResolver {
    private static final Logger log = LoggerFactory.getLogger(CustomDialectResolver.class);

    public Dialect resolveDialect(DialectResolutionInfo info) {
        int databaseMajorVersion;
        String databaseName = info.getDatabaseName();
        if (databaseName.startsWith("Microsoft SQL Server")) {
            int databaseMajorVersion2 = info.getDatabaseMajorVersion();
            if (databaseMajorVersion2 > 10) {
                log.debug("Returning custom SQL Server 2012 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion2);
                return new CustomSqlServer2012Dialect();
            }
            if (databaseMajorVersion2 == 10) {
                log.debug("Returning custom SQL Server 2008 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion2);
                return new CustomSqlServer2008Dialect();
            }
            if (databaseMajorVersion2 == 9) {
                log.debug("Returning custom SQL Server 2005 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion2);
                return new CustomSqlServer2005Dialect();
            }
            log.debug("Returning custom SQL Server 2000 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion2);
            return new CustomSqlServerDialect();
        }
        if ("MySQL".equals(databaseName)) {
            log.debug("Returning custom MySQL dialect for {}", (Object)databaseName);
            return new CustomMySqlDialect();
        }
        if ("PostgreSQL".equals(databaseName)) {
            int databaseMajorVersion3 = info.getDatabaseMajorVersion();
            int databaseMinorVersion = info.getDatabaseMinorVersion();
            if (databaseMajorVersion3 == 9) {
                log.debug("Returning custom PostgreSQL 9 dialect for {} (Version: {}.{})", new Object[]{databaseName, databaseMajorVersion3, databaseMinorVersion});
                return new CustomPostgres9Dialect();
            }
            if (databaseMajorVersion3 == 8 && databaseMinorVersion >= 2) {
                log.debug("Returning custom PostgreSQL 8.2 dialect for {} (Version: {}.{})", new Object[]{databaseName, databaseMajorVersion3, databaseMinorVersion});
                return new CustomPostgres82Dialect();
            }
            log.debug("Returning custom PostgreSQL 8.1 dialect for {} (Version: {}.{})", new Object[]{databaseName, databaseMajorVersion3, databaseMinorVersion});
            return new CustomPostgres81Dialect();
        }
        if ("Oracle".equals(databaseName) && (databaseMajorVersion = info.getDatabaseMajorVersion()) > 9) {
            log.debug("Returning Oracle 10g dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
            return new Oracle10gDialect();
        }
        return null;
    }
}

