/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.Product;
import com.atlassian.stash.cluster.ClusterService;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.MigrationTarget;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationTarget;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DatabaseValidationException;
import com.atlassian.stash.internal.db.DatabaseValidator;
import com.atlassian.stash.internal.db.DetailedDatabase;
import java.sql.Connection;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="databaseValidator")
public class DefaultDatabaseValidator
implements DatabaseValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseValidator.class);
    private final ClusterService clusterService;
    private final DatabaseSupplier databaseSupplier;
    private final I18nService i18nService;

    public DefaultDatabaseValidator(DatabaseSupplier databaseSupplier, I18nService i18nService) {
        this(null, databaseSupplier, i18nService);
    }

    @Autowired
    public DefaultDatabaseValidator(ClusterService clusterService, DatabaseSupplier databaseSupplier, I18nService i18nService) {
        this.clusterService = clusterService;
        this.databaseSupplier = databaseSupplier;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(@Nonnull DataSource dataSource) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            DetailedDatabase database = this.databaseSupplier.getForConnection(connection);
            if (database.getSupportLevel() == DatabaseSupportLevel.UNSUPPORTED) {
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.unsupporteddatabase", new Object[]{Product.NAME, database.getName(), database.getVersion()}));
            }
            if (this.isDataCenter() && !database.isClusterable()) {
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.notclusterable", new Object[]{Product.DATA_CENTER_NAME, database.getName(), database.getVersion()}));
            }
            MigrationTarget target = this.createMigrationTarget(connection);
            if (!target.isUtf8()) {
                log.debug("The target database is not configured for UTF-8 support");
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.validation.notutf8", new Object[]{Product.NAME}));
            }
            if (!target.hasNoClashingTables()) {
                log.debug("The target database contains {} tables", (Object)Product.NAME);
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.validation.notempty", new Object[]{Product.NAME}));
            }
            if (!target.hasRequiredSchemaPermissions()) {
                log.debug("The database user does not have the required schema permissions");
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.validation.insufficientpermissions", new Object[]{Product.NAME}));
            }
            if (!target.hasRequiredTemporaryTablePermission()) {
                log.debug("The database user does not have the required temporary table permission");
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.validation.insufficienttemporarytablepermission", new Object[]{Product.NAME}));
            }
            if (!target.isCaseSensitive()) {
                log.debug("The target database is not case sensitive.");
                throw new DatabaseValidationException(this.i18nService.createKeyedMessage("stash.db.validation.notcasesensitive", new Object[]{Product.NAME}));
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    protected MigrationTarget createMigrationTarget(Connection connection) {
        return new LiquibaseMigrationTarget(connection);
    }

    private boolean isDataCenter() {
        return this.clusterService != null && this.clusterService.isAvailable();
    }
}

